set echo ON;
spool /datos/p06b/log/salida_20170130P06AP06B23T00.log;

CREATE TABLE P06B23T00_ENT_ASEGURADORAS (
	P06B23_EA_CLAVE         VARCHAR2(5) NOT NULL,
	P06B23_EA_ENTIDAD       VARCHAR2(150) NOT NULL,
	P06B23_EA_CIF           VARCHAR2(20),
	P06B23_EA_TELEFONO   	VARCHAR2(20),
	P06B23_EA_ESTADO 		VARCHAR2(50),
	P06B23_EA_BAJA    		NUMBER(1) NOT NULL
)
TABLESPACE P0601E00;

CREATE SYNONYM P06B23S00 FOR P06B23T00_ENT_ASEGURADORAS;

ALTER TABLE P06B23T00_ENT_ASEGURADORAS ADD CONSTRAINT P06B23I00 PRIMARY KEY
	(P06B23_EA_CLAVE) USING INDEX TABLESPACE P0602E00;

CREATE INDEX P06B23I01 ON P06B23T00_ENT_ASEGURADORAS
	(P06B23_EA_CIF) TABLESPACE P0602E00;
	
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0001';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0001','ASEGURADORES AGRUPADOS, SOCIEDAD ANONIMA DE SEGUROS','A37001369','981175296','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0002';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0002','ALIANZA ESPAOLA S.A. DE SEGUROS LA','A28072197','914351157','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0007';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0007','FAMILIAR DE SEGUROS ACTIVE, SOCIEDAD ANONIMA','A46001186','963516543','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0012';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0012','ETERNA ASEGURADORA, S. A. COMPAIA DE SEGUROS Y REASEGUROS','A15009244','915380317','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0016';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0016','AURA, SOCIEDAD ANONIMA DE SEGUROS.','A08169674','934661100','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0026';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0026','BILBAO, COMPAIA ANONIMA DE SEGUROS Y REASEGUROS.','A48001648','944898100','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0031';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0031','CAJA DE SEGUROS REUNIDOS, COMPAIA DE SEGUROS Y REASEGUROS, S.A. (CASER)','A28013050','915955000','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0032';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0032','IPRESA IGUALATORIO DE PREVISION SANITARIA, SOCIEDAD ANONIMA DE SEGUROS.','A20022190','943463733','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0037';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0037','SANTANDER SEGUROS Y REASEGUROS, COMPAIA ASEGURADORA, S.A.','A46003273','912890994','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0039';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0039','ZURICH VIDA, COMPAIA DE SEGUROS Y REASEGUROS, S.A.','A08168213','913463874','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0046';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0046','COMPAIA ESPAOLA DE SEGUROS Y REASEGUROS DE CREDITO Y CAUCION, S.A.','A28008795','914326300','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0058';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0058','MAPFRE ESPAA, COMPAIA DE SEGUROS Y REASEGUROS, S.A.','A28141935','915816300','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0069';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0069','ESPAA, S.A., CIA. NACIONAL DE SEGUROS.','A28008647','914355980','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0072';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0072','GENERALI ESPAA, SOCIEDAD ANNIMA DE SEGUROS Y REASEGUROS','A28007268','913301400','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0075';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0075','LA FE PREVISORA COMPAIA DE SEGUROS, S.A.','A36601052','986229300','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0089';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0089','GES, SEGUROS Y REASEGUROS, S.A.','A28008712','913308585','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0109';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0109','ALLIANZ, COMPAIA DE SEGUROS Y REASEGUROS, S.A.','A28007748','902232629','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0114';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0114','MARTIERRA SEGUROS, S.A.','A28034890','914413435','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0120';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0120','ERGO GENERALES SEGUROS Y REASEGUROS, S.A.','A28072940','914565600','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0121';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0121','METROPOLIS, S.A., COMPAIA NACIONAL DE SEGUROS Y REASEGUROS.','A28001758','915324896','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0124';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0124','SEGURCAIXA ADESLAS, SOCIEDAD ANONIMA DE SEGUROS Y REASEGUROS','A28011864','932278700','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0133';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0133','OCASO, S.A., COMPAIA DE SEGUROS Y REASEGUROS.','A28016608','915380100','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0139';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0139','PATRIA HISPANA, S.A. DE SEGUROS Y REASEGUROS','A28007649','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0140';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0140','IBERCAJA VIDA, COMPAIA DE SEGUROS Y REASEGUROS, S.A.','A46013058','976767604','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0149';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0149','PREVISORA BILBAINA SEGUROS, S.A.','A48018204','944255491','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0155';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0155','PREVENTIVA, CIA. DE SEGUROS Y REASEGUROS, S.A.','A28027332','917102510','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0156';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0156','ATLANTIS, COMPAIA DE SEGUROS Y REASEGUROS, S.A.-Sociedad unipersonal','A08168619','934826751','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0157';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0157','HELVETIA COMPAIA SUIZA, SOCIEDAD ANONIMA DE SEGUROS Y REASEGUROS','A41003864','954593200','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0159';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0159','LA PREVISION POPULAR DE SEGUROS, S.A.','A17004771','972501750','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0161';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0161','DKV SEGUROS Y REASEGUROS, SOCIEDAD ANONIMA ESPAOLA','A50004209','976289100','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0174';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0174','SANTA LUCIA, S.A. COMPAIA DE SEGUROS Y REASEGUROS','A28039790','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0182';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0182','SEGUROS SEVILLA, S.A.','A41006693','954538244','Activa/Transferida CCAA Andaluca',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0188';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0188','LA UNION ALCOYANA, S.A. DE SEGUROS Y REASEGUROS.','A03007770','965540099','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0208';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0208','UNION MEDICA LA FUENCISLA, S.A. COMPAIA DE SEGUROS.','A08169609','976289170','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0215';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0215','VITAL SEGURO, S.A.','A08168361','936020602','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0222';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0222','ATLANTIDA MEDICA DE ESPECIALIDADES, S.A. DE SEGUROS.','A08169633','932172299','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0223';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0223','ATOCHA, S.A. DE SEGUROS','A28000677','915470060','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0225';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0225','CLINICUM SEGUROS, SOCIEDAD ANONIMA','A08169690','932371122','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0238';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0238','PARAISO UNIVERSAL, COMPAIA ESPAOLA DE SEGUROS, S.A.','A41003211','952222996','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0247';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0247','DIVINA PASTORA, SEGUROS GENERALES, S.A.U.','A20002002','963113340','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0275';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0275','NORTEHISPANA DE SEGUROS Y REASEGUROS, S.A.','A08185589','933027815','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0279';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0279','LA PREVISION MALLORQUINA DE SEGUROS, S.A.','A08169013','934150898','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0290';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0290','AME, ASISTENCIA MEDICA COMPAIA DE SEGUROS, S.A.','A08169385','934536954','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0311';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0311','ALMUDENA COMPAA DE SEGUROS Y REASEGUROS, S.A.','A28061083','914154111','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0315';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0315','HERCULES SALUD SEGUROS, S.A.','A15008931','981169070','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0320';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0320','SANITAS, SOCIEDAD ANONIMA DE SEGUROS.','A28037042','915852567','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0323';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0323','POLICLINICO, CENTRO MEDICO DE SEGUROS, S.A.','A33004318','985250300','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0325';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0325','ASISTENCIA CLINICA UNIVERSITARIA DE NAVARRA, S.A. DE SEGUROS Y REASEGUROS','A50005586','948194600','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0353';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0353','COMPAIA DE SEGUROS PREVISION MEDICA, S.A.','A29003381','952216522','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0355';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0355','EXPERTIA, SEGUROS DE DECESOS, S.A.','A33003906','917102510','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0368';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0368','LA UNION MADRILEA DE SEGUROS, S.A.','A28081818','914481714','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0384';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0384','IGUALATORIO MEDICO QUIRURGICO COLEGIAL, S.A. DE SEGUROS.','A39002357','942229600','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0388';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0388','PREVISORA ESPAOLA DE ESPECIALIDADES Y SEGUROS, SOCIEDAD ANONIMA','A08169666','972671603','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0391';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0391','IGUALATORIO MEDICO QUIRURGICO Y DE ESPECIALIDADES DE ASTURIAS, S.A. DE SEGUROS','A33602814','985-34.05.20','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0394';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0394','ASOCIACION EUROPEA COMPAIA DE SEGUROS, S.A.','A28026482','915312069','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0396';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0396','D.A.S. DEFENSA DEL AUTOMOVILISTA Y DE SINIESTROS-INTERNACIONAL, SOCIEDAD ANONIMA DE SEGUROS Y REASEGUROS (SOCIEDAD UNIPERSONAL)','A08055196','93-4.54.77.05','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0414';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0414','INSTITUTO SANITARIO, S.A. DE SEGUROS','A08169682','937902214','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0416';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0416','ASISTENCIA SANITARIA COLEGIAL, SOCIEDAD ANONIMA DE SEGUROS','A08169526','93-4.95.44.44','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0437';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0437','AGRUPACION SANITARIA DE SEGUROS, S.A.','A28005312','965200106','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0448';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0448','SALUS ASISTENCIA SANITARIA, S.A. DE SEGUROS','A33603168','985222480','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0461';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0461','ASISA, ASISTENCIA SANITARIA INTERPROVINCIAL DE SEGUROS, S.A., SOCIEDAD UNIPERSONAL','A08169294','915957500','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0465';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0465','COMPAIA DE SEGUROS IGUALATORIO MEDICO QUIRURGICO Y DE ESPECIALIDADES DE NAVARRA, SOCIEDAD ANONIMA','A31005432','948290400','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0467';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0467','LIBERTY SEGUROS, COMPAIA DE SEGUROS Y REASEGUROS, S.A.','A48037642','913017900','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0468';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0468','SEGUROS CATALANA OCCIDENTE, SOCIEDAD ANONIMA DE SEGUROS Y REASEGUROS','A28119220','935820500','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0494';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0494','MERIDIANO, S.A., COMPAIA ESPAOLA DE SEGUROS','A18006296','952221628','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0502';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0502','BBVASEGUROS, S.A., DE SEGUROS Y REASEGUROS','A48051098','902120010','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0511';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0511','MAPFRE VIDA, S.A. DE SEGUROS Y REASEGUROS SOBRE LA VIDA HUMANA','A28229599','915811400','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0516';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0516','COMPAIA ESPAOLA DE SEGUROS DE CREDITO A LA EXPORTACION, S.A., COMPAIA DE SEGUROS Y REASEGUROS (CESCE)','A28264034','914234800','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0517';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0517','PLUS ULTRA SEGUROS GENERALES Y VIDA, S.A. DE SEGUROS Y REASEGUROS','A30014831','917447500','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0554';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0554','COSALUD, SOCIEDAD ANNIMA DE SEGUROS','A08430258','934840780','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0556';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0556','AMAYA COMPAIA DE SEGUROS Y REASEGUROS, S.A.','A28496370','91-596.22.50','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0557';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0557','BANSABADELL VIDA, S.A. DE SEGUROS Y REASEGUROS','A08371908','937289514','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0559';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0559','CNP PARTNERS DE SEGUROS Y REASEGUROS S.A.','A28534345','915243400','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0569';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0569','SADYR SOCIEDAD ANONIMA DE SEGUROS Y REASEGUROS','A08675498','913194542','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0571';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0571','SOLUNION SEGUROS DE CRDITO, COMPAIA INTERNACIONAL DE SEGUROS Y REASEGUROS, S.A.','A28761591','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0572';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0572','SEGUROS LAGUN ARO, S.A.','A20079224','944798300','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0595';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0595','RGA RURAL VIDA, S.A. DE SEGUROS Y REASEGUROS','A78229663','917007000','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0599';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0599','UNION DEL DUERO, CIA. DE SEGUROS GENERALES, S.A.','A37042983','915139000','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0601';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0601','UNION DEL DUERO, COMPAIA DE SEGUROS DE VIDA, S.A.','A37042975','915798530','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0610';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0610','BANKINTER SEGUROS DE VIDA, S.A. DE SEGUROS Y REASEGUROS','A78510138','913397500','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0611';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0611','VIDA CAIXA, S.A. DE SEGUROS Y REASEGUROS','A58333261','932278700','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0613';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0613','REALE SEGUROS GENERALES, S.A.','A78520293','91-4.54.74.03','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0616';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0616','RGA SEGUROS GENERALES RURAL, S.A. DE SEGUROS Y REASEGUROS','A78524683','917007000','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0619';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0619','SEGUROS DE VIDA Y PENSIONES ANTARES, S.A.','A78586344','914179950','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0626';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0626','CCM VIDA Y PENSIONES DE SEGUROS Y REASEGUROS, SOCIEDAD ANONIMA','A16029191','969240460','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0627';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0627','S.O.S. SEGUROS Y REASEGUROS, S.A.','A78562246','91-5.72.43.00','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0628';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0628','ABANCA VIDA Y PENSIONES DE SEGUROS Y REASEGUROS, S.A','A15140387','902390450','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0631';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0631','UNION DE AUTOMOVILES CLUBS, S.A. DE SEGUROS Y REASEGUROS (UNACSA)','A78490539','915947400','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0637';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0637','UNICORP VIDA, COMPAIA DE SEGUROS Y REASEGUROS, S.A.','A78804390','952209004','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0643';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0643','SA NOSTRA COMPAA DE SEGUROS DE VIDA, S.A.','A07289531','971228060','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0652';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0652','CASER MEDITERRNEO SEGUROS GENERALES, S.A.','A58771247','915955053','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0654';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0654','KUTXABANK VIDA Y PENSIONES COMPAIA DE SEGUROS Y REASEGUROS, S.A.','A48272363','944017000','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0661';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0661','ASEGURADORA VALENCIANA SOCIEDAD ANONIMA DE SEGUROS Y REASEGUROS','A46429353','915811400','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0668';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0668','EUROP ASSISTANCE ESPAA, S.A. DE SEGUROS Y REASEGUROS','A28461994','915972125','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0676';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0676','MAPFRE ASISTENCIA, COMPAIA INTERNACIONAL DE SEGUROS Y REASEGUROS, S.A.','A79194148','915819548','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0677';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0677','MEDITERRANEO VIDA, SOCIEDAD ANONIMA DE SEGUROS Y REASEGUROS','A03359635','965905433','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0679';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0679','AMSYR AGRUPACI SEGUROS Y REASEGUROS, S.A.','A79202420','934826600','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0682';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0682','AMIC SEGUROS GENERALES, S.A. SOCIEDAD UNIPERSONAL','A78920105','915771676','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0683';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0683','SEGUROS LAGUN ARO VIDA, S.A.','A20182705','944798300','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0688';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0688','ALLIANZ POPULAR VIDA, COMPAIA DE SEGUROS Y REASEGUROS, S.A., SOCIEDAD UNIPERSONAL','A78694197','914360300','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0692';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0692','AIDE ASISTENCIA SEGUROS Y REASEGUROS, S.A.','A08752206','932800061','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0693';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0693','PELAYO VIDA SEGUROS Y REASEGUROS, S.A.','A47091665','915915040','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0694';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0694','AVIVA VIDA Y PENSIONES, SOCIEDAD ANONIMA DE SEGUROS Y REASEGUROS','A79381729','912971700','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0696';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0696','ERGO VIDA SEGUROS Y REASEGUROS, SOCIEDAD ANONIMA','A79420899','976289100','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0697';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0697','SEGUROS EL CORTE INGLES, VIDA, PENSIONES Y REASEGUROS, S.A.','A79346839','914017362','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0701';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0701','BARCLAYS VIDA Y PENSIONES COMPAIA DE SEGUROS, S.A.U.','A79500815','913361400','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0706';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0706','FENIX DIRECTO, COMPAIA DE SEGUROS Y REASEGUROS, S.A.','A80029150','902-44.44.44','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0708';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0708','AMGEN SEGUROS GENERALES, COMPAA DE SEGUROS Y REASEGUROS, S.A Sociedad Unipersonal.','A59575365','934826751','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0709';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0709','IMA IBERICA DE SEGUROS Y REASEGUROS, S.A.','A78689726','913434900','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0711';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0711','AXA AURORA VIDA, S.A. DE SEGUROS Y REASEGUROS','A48464606','911116961','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0715';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0715','ASEFA S.A., SEGUROS Y REASEGUROS','A08171605','917812200','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0720';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0720','LINEA DIRECTA ASEGURADORA SOCIEDAD ANNIMA COMPAIA DE SEGUROS Y REASEGUROS','A80871031','918072000','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0721';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0721','KUTXABANK ASEGURADORA COMPAIA DE SEGUROS Y REASEGUROS, S.A.','A48505028','944018261','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0723';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0723','AXA SEGUROS GENERALES, S. A. DE SEGUROS Y REASEGUROS','A60917978','911116961','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0724';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0724','AXA VIDA, SOCIEDAD ANONIMA DE SEGUROS Y REASEGUROS','A60917911','911116961','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0730';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0730','AXA GLOBAL DIRECT SEGUROS Y REASEGUROS, S.A.','A81357246','91-5.38.81.40','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0732';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0732','MAPFRE GLOBAL RISKS, COMPAIA INTERNACIONAL DE SEGUROS Y REASEGUROS, S.A.','A28204006','91-581.13.00','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0735';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0735','PASTOR VIDA, S.A. DE SEGUROS Y REASEGUROS','A15633308','915249850','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0736';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0736','NATIONALE-NEDERLANDEN VIDA, COMPAIA DE SEGUROS Y REASEGUROS SOCIEDAD ANONIMA ESPAOLA','A81946485','916400404','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0737';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0737','NATIONALE-NEDERLANDEN GENERALES, COMPAIA DE SEGUROS Y REASEGUROS, SOCIEDAD ANONIMA ESPAOLA','A81946501','916400404','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0739';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0739','CAJA ESPAA VIDA, COMPAIA DE SEGUROS Y REASEGUROS SOCIEDAD ANONIMA','A82070442','987292526','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0744';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0744','ATLANTIS VIDA, COMPAIA DE SEGUROS Y REASEGUROS, SOCIEDAD ANONIMA','A61944203','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0747';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0747','LAIETANA VIDA, COMPAIA DE SEGUROS DE LA CAJA DE A HORROS LAIETANA, S.A., SOCIEDAD UNIPERSONAL','A62456322','937417500','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0754';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0754','MARCH VIDA, SOCIEDAD ANONIMA DE SEGUROS Y REASEGUR OS','A57193492','971779284','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0756';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0756','LIBERBANK VIDA Y PENSIONES, SEGUROS Y REASEGUROS, S.A.','A74087081','985207053','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0757';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0757','CAJAMAR VIDA, SOCIEDAD ANONIMA DE SEGUROS Y REASEG UROS','A04465555','950210111','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0758';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0758','IGUALATORIO MEDICO QUIRURGICO, S.A. DE SEGUROS Y REASEGUROS','A95321386','944423450','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0761';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0761','CATALUNYACAIXA ASSEGURANCES GENERALS, SOCIETAT ANNIMA D**ASSEGURANCES I REASSEGURANCES','A64067325','934848130','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0765';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0765','PREVISORA BILBAINA VIDA SEGUROS, S.A.','A95431888','946612508','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0767';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0767','BANSABADELL SEGUROS GENERALES, SOCIEDAD ANNIMA DE SEGUROS Y REASEGUROS','A64194590','902030255','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0769';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0769','CAJAMURCIA VIDA Y PENSIONES DE SEGUROS Y REASEGUROS, S.A.','A73505158','902330090','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0770';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0770','CAJA GRANADA VIDA, COMPAIA DE SEGUROS Y REASEGUROS, SOCIEDAD ANONIMA','A18474189','958216170','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0771';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0771','LEGALITAS COMPAIA DE SEGUROS Y REASEGUROS, S.A.','A85180289','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0772';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0772','CAI Seguros Generales de Seguros y Reaseguros S.A.','A99169591','976308946','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0775';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0775','SAHNA-E SERVICIOS INTEGRALES DE SALUD, SOCIEDAD ANONIMA DE SEGUROS Y REASEGUROS','A85372597','913834709','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0777';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0777','CAIXA ENGINYERS VIDA-CAJA INGENIEROS VIDA, COMPAIA DE SEGUROS Y REASEGUROS, S.A.','A64097892','933126700','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0778';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0778','BANKIA MAPFRE VIDA, SOCIEDAD ANONIMA DE SEGUROS Y REASEGUROS','A80434699','91-5.81.14.02','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0780';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0780','CAJAMAR SEGUROS GENERALES, SOCIEDAD ANONIMA DE SEGUROS Y REASEGUROS','A04653556','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0781';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0781','MM GLOBALIS, S.A.U. DE SEGUROS Y REASEGUROS','A85669604','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0784';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0784','REALE VIDA Y PENSIONES, SOCIEDAD ANNIMA DE SEGUROS','A85877066','91-4547403','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0785';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0785','VERTI ASEGURADORA, COMPAA DE SEGUROS Y REASEGUROS, S.A.','A85078301','911758960','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0786';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0786','MM HOGAR SOCIEDAD ANNIMA UNIPERSONAL DE SEGUROS Y REASEGUROS','A86007572','902555555','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0789';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0789','AEGON ESPAA, SOCIEDAD ANNIMA DE SEGUROS Y REASEGUROS','A15003619','915636222','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0790';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0790','AGRUPACI AMCI D*ASSEGURANCES I REASSEGURANCES, S.A.','A65782807','934826600','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0791';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0791','BANKINTER SEGUROS GENERALES, S.A. DE SEGUROS Y REASEGUROS','A78801172','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0793';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0793','MURIMAR VIDA SEGUROS Y REASEGUROS, S.A.','A85490407','915980766','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0794';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0794','MGS SEGUROS Y REASEGUROS S.A.','A08171373','933221212','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0795';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0795','AEGON SANTANDER VIDA SEGUROS Y REASEGUROS, S.A.','A86588068','912890969','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0796';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0796','AEGON SANTANDER GENERALES SEGUROS Y REASEGUROS, S.A.','A86588050','912890969','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0797';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0797','CA LIFE INSURANCE EXPERTS COMPAIA DE SEGUROS Y REASEGUROS, S.A.U.','A86485794','913896017','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0801';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0801','ASISA VIDA SEGUROS, S.A.U.','A87425070','915957501','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'C0802';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('C0802','AGROPELAYO SOCIEDAD DE SEGUROS, SOCIEDAD ANNIMA','A87254090','915920100','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0103';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0103','TOKIO MARINE EUROPE INSURANCE LIMITED','W0061686B','932040856','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0115';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0115','SOMPO JAPAN INSURANCE CO OF EUROPE LTD SUC.ESPAA','W0064257I','934012704','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0116';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0116','COMPAGNIE FRANCAISE D*ASSURANCE POUR LE COMMERCE EXTERIEUR SUC.ESPAA','W0012052G','913104224','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0118';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0118','FIDELIDADE COMPANHIA DE SEGUROS S.A SUC.ESPAA','W0101170I','915637788','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0121';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0121','GNB- COMPANHIA DE SEGUROS DE VIDA S.A SUC.EN ESPAA','W0101151I','915667210','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0123';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0123','COMPANHIA DE SEGS.TRANQUILIDADE, S.A.','W0101150I','915667210','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0124';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0124','MBIA INSURANCE CORPORATION, ENTIDAD ASEGURADORA NORTEAMERICANA, SUCURSAL EN ESPAA','G81249062','914361045','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0125';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0125','PREDICA -PREVOYANCE DIALOGUE CREDIT AGRICOLE SUC ESPAA','W0012417B','943572431','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0126';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0126','LONDON GENERAL INSURANCE COMPANY LIMITED SUC.ESPAA','N0064975F','932419830','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0127';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0127','DOMESTIC # GENERAL INSURANCE PLC SUC.ESPAA','W0062561F','913107750','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0128';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0128','HSB ENGINEERING INSURANCE LTD SUC ESPAA','N0064491D','915643158','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0129';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0129','CARDIF ASSURANCE VIE, SUCURSAL EN ESPAA','W0012421D','915903001','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0130';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0130','CARDIF ASSURANCES RISQUES DIVERS SUC.ESPAA','W0012420F','915903001','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0133';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0133','CIGNA LIFE INSURANCE COMPANY OF EUROPE S.A., SUCUR SAL EN ESPAA','N0021205J','914184900','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0134';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0134','XL INSURANCE CO SE, SUCURSAL EN ESPAA','W0065403H','917023300','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0138';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0138','AXA ART VERSICHERUNG AG, SUCURSAL EN ESP','W0042565B','917815890','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0141';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0141','MEDIOLANUM INTERNATIONAL LIFE DESIGNATED ACTIVITY COMPANY SUC.ESPAA','W0071457F','932535542','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0142';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0142','LLOYD*S SUCURSAL EN ESPAA (PRESENCIA PERMANENTE DE LLOYD*S ASSOCIATION OF UNDERWRITERS)','W0066414D','914262312','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0143';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0143','ICARE ASSURANCE','N0013171D','915149801','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0145';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0145','AMT MORTGAGE INSURANCE LIMITED, SUC ESPA','N0066589C','914444008','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0147';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0147','AXA CORPORATE SOLUTIONS ASSURANCES','W0013232D','915385822','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0148';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0148','EUROMAF SA ASSURANCE INGENIEURS ET ARQUI','N0013307D','915401902','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0152';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0152','ASPECTA ASSURANCE INTERNATIONAL LUXEMBUR','W1081054G','917441280','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0154';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0154','LONDON GENERAL LIFE COMPANY LIMITED SUC.EN ESPAA','W0067319D','932419830','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0155';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0155','ACE EUROPEAN GROUP LIMITED SUC.ESPAA','W0067389G','918374977','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0158';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0158','SCOR GLOBAL LIFE IBERICA SUCURSAL','W0013499I','914490810','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0159';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0159','HISCOX INSURANCE COMPANY LIMITED SUC.ESPAA','W0067406I','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0159';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0159','HISCOX INSURANCE COMPANY LIMITED SUC.ESPAA','W0067406I','915759469','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0160';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0160','CNP ASSURANCES SUCURSAL EN ESPAA','W0013620J','915243400','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0161';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0161','CNP IAM SUCURSAL EN ESPAA','W0013619B','915243400','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0162';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0162','ARCH INSURANCE COMPANY (EUROPE) LIMITED','N0067946D','915320009','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0163';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0163','MARKEL INTERNATIONAL INSURANCE COMPANY','W0068002E','914177756','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0164';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0164','LIGHTHOUSE LIFE ASSURANCE COMPANY LTD(GIBRALTAR)','W0068296C','917816300','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0165';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0165','LIGHTHOUSE GENERAL INSURANCE COMPANY LTD (GIBRALTAR)','W0068295E','917816300','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0166';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0166','W.R. BERKLEY INSURANCE (EUROPE)LIMITED SUC.EN ESPAA','W0068409B','914492646','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0168';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0168','QBE INSURANCE (EUROPE) LIMITED SUC.EN ESPAA','W0068587E','917893950','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0169';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0169','ADMIRAL INSURANCE COMPANY LIMITED SUC.EN ESPAA','W0068776D','955010100','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0171';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0171','TRADE CREDIT RE INSURANCE COMPANY SUC.EN ESPAA','W0171343G','961366694','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0172';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0172','AXA LIFE EUROPE DAC SUC.EN ESPAA','W0071771J','915385652','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0173';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0173','AXERIA PREVOYANCE SUC.EN ESPAA','W0014512H','915717711','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0174';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0174','LIBERTY MUTUAL INSURANCE EUROPE LIMITED SUC.EN ESPAA','W0069547H','914442867','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0175';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0175','ACE EUROPE LIFE LIMITED, SUCURSAL EN ESPAA','','902010134','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0176';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0176','AIOI NISSAY DOWA INSURANCE COMPANY OF EUROPE LIMITED SUC ESPAA','W0060072F','914900073','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0178';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0178','RGA INTERNATIONAL REINSURANCE COMPANY DAC SUC.EN ESPAA','W0071890H','916404340','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0179';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0179','SWISS RE EUROPE S.A SUC.ESPAA','W0181839B','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0180';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0180','ALICO LIFE INTERNATIONAL LIMITED SUC EN ESPAA','W0072006J','915982844','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0183';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0183','BUPA INSURANCE LIMITED SUC.ESPAA','N0611147','952471204','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0184';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0184','ROYAL # SUN ALLIANCE INSURANCE PLC SUC.ESPAA','W0060964D','911102436','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0185';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0185','CHUBB INSURANCE COMPANY OF EUROPE SE SUC.ESPAA','W0060918J','913083468','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0189';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0189','ZURICH INSURANCE PLC SUC.ESPAA','W0072130H','933067300','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0190';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0190','CG CAR-GARANTIE VERSICHERUNGS-AKT SUC.ESPAA','W0046688H','961576795','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0191';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0191','HCC INTERNATIONAL INSURANCE COMPANY PLC SUC.EN ESPAA','W0060927A','915560888','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0192';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0192','CNA INSURANCE COMPANY LIMITED SUC.ESPAA','W8260555A','917816300','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0193';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0193','ALLIANZ GLOBAL CORPORATE # SPECIALTY S.E. SUC ESPAA','W0047088J','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0194';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0194','FINANCIAL ASSURANCE COMPANY LIMITED SUC.ESPAA','W4005583B','913081116','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0195';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0195','FINANCIAL INSURANCE COMPANY LIMITED SUC ESPAA','W8261031B','913081116','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0196';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0196','INTER PARTNER ASSISTANCE SA SUC.ESPAA','W0171985E','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0197';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0197','FM INSURANCE COMPANY LIMITED SUC.ESPAA','W8261515D','913837713','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0198';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0198','ASSURANT GENERAL INSURANCE LIMITED SUC ESPAA','W8261765E','912682900','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0199';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0199','ACM VIE S.A SUCURSAL EN ESPAA','W0017546C','914907094','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0200';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0200','ACM IARD S.A SUCURSAL EN ESPAA','W00175481','911146820','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0201';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0201','ELITE INSURANCE COMPANY LIMITED SUC ESPAA','W0440746F','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0202';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0202','AWP P#C SUCURSAL EN ESPAA','W0034957A','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0203';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0203','ASSURANT LIFE LIMITED SUC ESPAA','W8262406E','912682900','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0206';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0206','TELEFONICA INSURANCE SUC.ESPAA','W01827981','914831550','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0207';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0207','AIG EUROPE LIMITED SUC.ESPAA','W8262878E','915677400','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0208';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0208','METLIFE EUROPE LIMITED SUC.ESPAA','W0072536F','902550366','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0209';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0209','METLIFE EUROPE INSURANCE DESIGNATED ACTVITY COMPANY SUC.ESPAA','W0072537D','902550366','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0210';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0210','ARAG SE SUC.ESPAA','W0049001A','933092412','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0211';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0211','SCOR GLOBAL P#C SE IBERICA SUCURSAL EN ESPAA','W0011696B','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0212';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0212','MSIG INSURANCE EUROPE AG SUC.ESPAA','W0049767G','911867981','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0213';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0213','HDI GLOBAL SE SUC.ESPAA','W0049757H','914442000','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0214';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0214','INTERLLOYD VERSICHERUNGS-AG SUCURSAL EN ESPAA','W0040394I','933006813','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0215';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0215','AXERIA SEGUROS SUCURSAL EN ESPAA','N0015964J','915642371','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0216';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0216','SWISS RE INTERNATIONAL SE SUCURSAL EN ESPAA','W0184229C','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0217';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0217','ERV SEGUROS DE VIAJE EUROPAISCHE REISEVERSICHERUNG AG SUC.ESPAA','W0040918E','913441737','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0218';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0218','W.R. BERKLEY EUROPE AG SUC. ESPAA','W0371455G','914492646','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0219';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0219','FWU LIFE INSURANCE LUX S.A SUC. EN ESPAA','W0184379F','917943000','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0220';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0220','SOCIETE HOSPITALIERE D*ASSURANCES MUTUELLES(SHAM) SUC.ESPAA','W0010878G','916629426','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'E0221';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('E0221','CNP CAUTION SUCURSAL ESPAA','W0010754J','915243400','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0001';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0001','ASSICURAZIONI GENERALI S.P.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0003';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0003','ASSICURAZIONI GENERALI S.P.A, AGENCIA GENERAL EN PORTUGAL.','','0039-040-671','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0005';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0005','ASSICURAZIONI GENERALI S.P.A SUC. REINO UNIDO','','0039-040-671','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0006';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0006','GENERALI HELLAS S.A. DES ASSURANCES DES DOMMAGES','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0007';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0007','GENERALI BELGIUM S.A.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0009';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0009','M.B.I.A ASSURANCE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0011';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0011','AIG EUROPE (BELGICA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0014';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0014','SHIPOWNERS* MUTUAL PROTECTION # INDEMNITY ASSOCIATION (LUXEMBOURG)','A 0901012 E','/25 29 20','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0015';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0015','MITSUI SUMITOMO INSURANCE COMPANY (EUROPE) LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0016';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0016','LONDON GENERAL INSURANCE COMPANY LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0017';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0017','LLOYD*S ASSOCIATION OF UNDERWRITERS','','0171 327 5926','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0018';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0018','WsRTTEMBERGISCHE VERSICHERUNG AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0019';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0019','THE BRITANNIA STEAM SHIP INSURANCE ASSOCIATION LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0020';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0020','TRAVELERS CASUALTY AND SURETY COMPANY OF EUROPE LTD','','0171 327 4022','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0021';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0021','GENERALI IARD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0022';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0022','CHARTERERS MUTUAL ASSURANCE ASSOCIATION LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0023';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0023','THE TRANSMARINE MUTUAL STRIKE ASSURANCE ASSOCIATION LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0025';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0025','MUTUAL MARINA INSURANCE ASSOCIATION LTD.INC.CO.LTD.BY GUARANTY','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0029';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0029','COMPAGNIE FRANCAISE D*ASSURANCE POUR LE COMMERCE EXTERIEUR','N0011713E','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0032';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0032','SOCIETE FRANCAISE D*ASSURANCE CREDIT','','1 40 70 50 17','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0033';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0033','EUROP ASSISTANCE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0039';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0039','TCS INSURANCE COMPANY OF IRELAND dac','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0040';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0040','ASSURANCEFORENINGEN SKULD (GJENSIDIG)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0041';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0041','FM INSURANCE COMPANY LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0043';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0043','EUROPAEISKE REJSEFORSIKRING A/S','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0044';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0044','PROFESSIONAL SERVICES INSURANCE COMPANY LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0045';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0045','BMS INTERNATIONAL INSURANCE COMPANY LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0049';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0049','MARTINSURANCE TEORANTA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0051';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0051','MIRIPRO INSURANCE COMPANY DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0056';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0056','NATIONALE-NEDERLANDEN SCHADEVERZEKERING MAATSCHAPPIJ N.V.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0062';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0062','AIG EUROPE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0063';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0063','INTERNATIONAL TRANSPORT INTERMEDIARIES CLUB LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0064';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0064','HSB ENGINEERING INSURANCE LIMITED','','44/0/1712473529','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0065';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0065','HEDDINGTON INSURANCE (U.K.) LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0067';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0067','GD INSURANCE COMPANY DAC','','35316789636','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0072';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0072','AXA ASSISTANCE FRANCE ASSURANCES','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0074';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0074','ACADIA INSURANCE INTERNATIONAL DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0075';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0075','MMA IARD ASSURANCES MUTUELLES','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0076';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0076','MMA VIE ASSURANCES MUTUELLES','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0089';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0089','CIGNA LIFE INSURANCE COMPANY OF EUROPE, S.A.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0090';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0090','CIGNA LIFE INSURANCE COMPANY OF EUROPE, SUC EN FRANCIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0093';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0093','AIG EUROPE LIMITED, SUCURSAL EN ALEMANIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0094';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0094','AIG EUROPE LIMITED SUCURSAL EN AUSTRIA.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0095';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0095','GREAT LAKES INSURANCE SE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0096';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0096','AIG EUROPE LIMITED, SUCURSAL EN DINAMARCA.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0097';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0097','AIG EUROPE LIMITED, SUCURSAL EN FINLANDIA.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0098';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0098','AIG EUROPE LIMITED, SUCURSAL EN ITALIA.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0099';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0099','AIG EUROPE LIMITED, SUCURSAL EN LUXEMBURGO.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0100';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0100','AIG EUROPE LIMITED, SUCURSAL EN NORUEGA.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0101';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0101','AIG EUROPE LIMITED, SUCURSAL EN PORTUGAL.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0102';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0102','AIG EUROPE LIMITED, SUCURSAL EN SUECIA.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0103';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0103','INTERNATIONAL HEALTH INSURANCE DANMARK,FORSIKRINGSAKTIESELSKAB','','45-33-32-25-60','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0106';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0106','USAA LIMITED (UNITED SERVICES AUTOMOBILE ASSOCIATION)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0106';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0106','USAA LIMITED (UNITED SERVICES AUTOMOBILE ASSOCIATION)','','1714917949','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0116';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0116','PROBUS INSURANCE COMPANY EUROPE DAC','8252557-F','353-1-2837821','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0117';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0117','HSBC LIFE (EUROPE) LIMITED','','01-671-6784','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0119';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0119','INDUSTRIA FTRSZKRINGSAKTIEBOLAG','A-0301484-B','46-08-743 9140','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0121';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0121','UNIPOLSAI ASSICURAZIONI S.P.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0123';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0123','ROYAL NEDERLAND SCHADEVERZEKERING N.V.','16.70.943','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0124';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0124','SIAT SOCIETA ITALIANA DI ASSICURAZIONI E RIASSICURAZIONI S.P.A.','522430107','010/ 562638','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0127';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0127','ALLIANZ VERSICHERUNGS - AKTIENGESELLSCHAFT','','089/34 99 41','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0128';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0128','LIFEGUARD INSURANCE (DUBLIN) DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0133';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0133','THE STANDARD CLUB EUROPE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0138';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0138','MITSUI SUMITOMO INSURANCE (LONDON) LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0139';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0139','AACHENMUNCHENER VERSICHERUNGS AG','','02 41 4564510','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0140';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0140','ZURICH EUROLIFE S.A.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0142';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0142','GENERALI VIDA, COMPAIA DE SEGUROS, S.A.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0143';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0143','MARKEL INTERNATIONAL INSURANCE COMPANY LIMITED','N0064993I','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0144';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0144','ALLIANZ IARD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0146';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0146','EULER HERMES KREDITVERSICHERUNGS-AKTIENGESELLSCHAFT','','040 88 34 10 25','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0155';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0155','ARISA ASSURANCES, S.A.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0158';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0158','PHILIP MORRIS INTERNATIONAL INSURANCE (IRELAND) DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0159';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0159','CANTERBURY INSURANCE DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0160';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0160','AKZO NOBEL ASSURANTIE N.V.','','31 26 366 55 90','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0162';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0162','GOUDSE SCHADEVERZEKERINGEN N.V','','0182 544 899','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0164';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0164','SOCIETA REALE MUTUA DI ASSICURAZIONI','875360018','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0166';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0166','SUNDERLAND MARINE MUTUAL INSURANCE COMPANY LIMITED','','915658625','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0167';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0167','SWISS LIFE (LUXEMBOURG) S.A.','','423960','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0171';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0171','COMPANHIA DE SEGUROS TRANQUILIDADE, S.A.','500 940 231','01 356 25 86','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0174';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0174','AXA CORPORATE SOLUTIONS ASSURANCE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0176';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0176','ERGO VERSICHERUNGS AKTIENGESELLSCHAFT','','0049/211-4770','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0178';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0178','PHOENIX LIFE LIMITED','','0171-826 1078','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0181';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0181','ALLIANZ INSURANCE PLC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0183';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0183','ASSURANCEFORENINGEN GARD- GJENSIDIG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0186';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0186','SCOTTISH MUTUAL INTERNATIONAL PLC','','353 804 4005','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0187';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0187','COMPANHIA DE SEGURO DE CREDITOS, S.A. (COSEC)','500 726 000','793 47 26','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0192';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0192','TT CLUB MUTUAL INSURANCE LIMITED','','2072042626','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0193';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0193','CNA INSURANCE COMPANY LIMITED','','2077433800','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0196';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0196','AXA VERSICHERUNG AG.','','(0221)148-23736','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0197';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0197','CARDIF ASSURANCE VIE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0199';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0199','MONDIAL ASSISTANCE EUROPE N.V.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0200';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0200','PI INDEMNITY COMPANY DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0204';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0204','SEB LIFE INTERNATIONAL ASSURANCE COMPANY LIMITED','','353 1 704 1922','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0207';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0207','GENERALI VERSICHERUNG AKTIENGESELLSCHAFT(AUSTRIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0208';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0208','HISCOX INSURANCE COMPANY LIMITED','','1714881702','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0209';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0209','ASSIDOMAN F0RSIKRINGSAKTIEBOLAG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0211';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0211','NAVILLUS INSURANCE COMPANY DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0212';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0212','FILO DIRETTO ASSICURAZIONI S.P.A.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0218';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0218','ABN AMRO LIFE S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0220';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0220','VABIS FORSAKRINGSAKTIEBOLAG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0222';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0222','AVIVA INTERNATIONAL INSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0225';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0225','VESTA FORSIKRING AS','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0226';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0226','PINE INDEMNITY DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0227';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0227','AXA VERSICHERUNG AG SUCURSAL EN IRLANDA','','(0221)148-105','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0230';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0230','UNILEVER INSURANCES N.V.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0231';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0231','FORTUNA LEBENS-VERSICHERUNGS AKTIENGESELLSCHAFT','','41 75 236 15 46','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0234';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0234','SUN LIFE ASSURANCE COMPANY OF CANADA (UK) LIMITED','','4401256425174','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0236';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0236','INDUSTRIFORSIKRING AS','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0237';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0237','EURESA-LIFE S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0239';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0239','REAL GARANT VERSICHERUNG AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0242';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0242','THE TOKIO MARINE EUROPE INSURANCE LTD (UK) LIMITED','','0171 283 7354/5','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0243';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0243','OVERSEAS NEIL DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0244';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0244','CHUBB BERMUDA INTERNATIONAL INSURANCE (IRELAND) DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0249';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0249','HARCOURT LIFE INTERNATIONAL DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0251';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0251','SCOTTISH WIDOWS PLC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0252';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0252','SCOTTISH WIDOWS ANNUITIES LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0253';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0253','ACREDIA VERSICHERUNG AG','','4310501020','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0257';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0257','SOGELIFE SA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0258';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0258','SUN INSURANCE OFFICE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0263';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0263','GENERALI LEVENSVERZEKERING MAATSCHAPPIJ N.V.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0265';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0265','LOMBARD INTERNATIONAL ASSURANCE S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0266';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0266','EXCELL LIFE INTERNATIONAL S.A','B74132','35226201540','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0268';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0268','LAGUNA LIFE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0269';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0269','CALI EUROPE S.A','','35226267030','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0271';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0271','ROYAL LIVER ASSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0272';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0272','VALORLIFE LEVENSVERSICHERUNGS-AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0276';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0276','AVIVA LIFE # PENSIONS IRELAND LIMITED','','353 1 677 4860','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0279';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0279','ASPECTA ASSURANCE INTERNATIONAL LUXEMBOURG S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0281';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0281','SCOR UK COMPANY LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0283';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0283','SIRIUS INTERNATIONAL FTRSZKRINGSAKTIEBOAG, SUCURSAL EN REINO UNIDO','','46 8 458 55 99','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0287';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0287','LIFE VALUE S.P.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0289';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0289','AXA WEALTH LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0290';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0290','INORA LIFE LIMITED','','6750300','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0292';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0292','HSBC INSURANCE (IRELAND) LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0295';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0295','OLD MUTUAL INTERNATIONAL LIFE IRELAND LIMITED','','35315009100','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0296';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0296','SOMPO JAPAN INSURANCE COMPANY OF EUROPE LIMITED(SUC.BELGICA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0297';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0297','SOMPO JAPAN INSURANCE COMPANY OF EUROPE LIMITED(SUC.ALEMANIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0298';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0298','SOMPO JAPAN INSURANCE COMPANY OF EUROPE LIMITED(SUC.PAISES BAJOS)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0302';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0302','UNION KRANKENVERSICHERUNG AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0303';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0303','WURZBURGER VERSICHERUNG AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0304';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0304','ASSURED GUARANTY (EUROPE) LIMITED','','2077108211','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0305';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0305','RED DISK INSURANCE DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0308';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0308','DELVAG VERSICHERUNGS AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0310';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0310','EURO-AVIATION VERSICHERUNGS-AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0311';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0311','ECCLESIASTICAL INSURANCE OFFICE PUBLIC LIMITED COMPANY','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0313';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0313','PA (GI) LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0316';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0316','AXA FRANCE IARD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0321';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0321','CNP UNICREDIT VITA SPA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0326';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0326','ADVO CARD RECHTSSCHUTZVERSICHERINGS-AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0327';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0327','COMPAGNIA ITALIANA RISCHI AZIENDE, SPA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0329';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0329','EURO INSURANCES DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0330';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0330','LA MONDIALE EUROPARTNER S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0333';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0333','AXA PPP HEALTHCARE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0334';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0334','GENERALI VIE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0335';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0335','CARDIF LUX VIE S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0336';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0336','COVEA LIFE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0337';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0337','THE ONELIFE COMPANY S.A','','3524567301','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0338';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0338','IF SKADEFORSAKRING AB(PUBL)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0339';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0339','ZURICH VERSICHERUNGS AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0342';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0342','PRUDENTIAL INTERNATIONAL ASSURANCE PLC','','353 1 476 5000','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0344';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0344','GROUPAMA ASSICURAZIONI S.P.A','','630181','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0346';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0346','TRYG FORSIKRING A/S','','44202020','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0348';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0348','SCA FORSAKRINGSAKTIEBOLAG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0350';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0350','QBE INSURANCE (EUROPA) LIMITED','','071 283 7405','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0351';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0351','GOLDEN ARCHES INSURANCE DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0352';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0352','NEWELL INSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0353';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0353','SOMPO JAPAN INSURANCE COMPANY OF EUROPE LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0355';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0355','NURNBERGER ALLGEMEINE VERSICHERUNGS-AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0359';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0359','R+V ALLGEMEINE VERSICHERUNG AKTIENGESELLCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0362';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0362','XL INSURANCE COMPANY SE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0363';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0363','IF SKADEFORSAKRING AB(PUBL)SUCURSAL FRANCIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0364';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0364','IF SKADEFORSAKRING AB(SUCURSAL PAISES BAJOS)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0365';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0365','IF SKADEFORSAKRING AB (PUBL)(SUCURSAL REINO UNIDO)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0366';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0366','IF SKADEFORSAKRING AB(SUCURSAL ALEMANIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0367';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0367','IF SKADEFORSAKRING AB(PUBL)SUCURSAL DINAMARCA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0368';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0368','IF SKADEFORSAKRING AB(PUBL)SUCURSAL FINLANDIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0369';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0369','IF SKADEFORSAKRING AB(PUBL) SUCURSAL NORUEGA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0370';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0370','HOMECARE INSURANCE LIMITED','','0845 1201021','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0371';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0371','VITIS LIFE S.A','','352262046300','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0372';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0372','EUROPEAN INSURANCE RISK EXCESS DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0374';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0374','CARRAIG INSURANCE DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0375';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0375','SCHWARZMEER UND OSTSEE VERSICHERUNGS-AKTIENGESELLSCHAFT SOVAG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0376';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0376','L*EQUITE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0377';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0377','OLD MUTUAL WEALTH LIFE ASSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0382';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0382','GENERALI VERSICHERUNG AKTIENGESELLSCHAFT(ALEMANIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0383';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0383','SEB TRYGG LIFE (IRELAND) ASSURANCE COMPANY LIMITED','','35314189830','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0385';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0385','HANSEMERKUR (S.A. DE SEGUROS DE VIAJE)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0386';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0386','WHITE ROCK INSURANCE (GIBRALTAR) PCC LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0387';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0387','SOCIETA*CATTOLICA DI ASSICURAZIONI COOPERATIVA A.R.L','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0388';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0388','ALLIANZ LIFE LUXEMBOURG S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0391';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0391','MILLENNIUM INSURANCE COMPANY LIMITED (GIBRALTAR)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0392';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0392','UPS INTERNATIONAL INSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0394';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0394','THE SHIPOWNERS*MUTUAL STRIKE INSURANCE ASSOCIATION EUROPE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0397';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0397','GROUPAMA ASSURANCE CREDIT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0398';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0398','THEMIS SOCIETE D*ASSURANCES','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0403';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0403','THE NORTH OF ENGLAND PROTECTING AND INDEMNITY ASSOCIATION LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0404';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0404','GENCON INSURANCE COMPANY INTERNATIONAL LIMITED (GIBRALTAR)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0406';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0406','STONEBRIDGE INTERNATIONAL INSURANCE LTD','','800007362','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0407';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0407','AXIS SPECIALTY EUROPE SE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0408';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0408','EULER HERMES SA NV','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0409';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0409','TOKIO MILLENIUM RE (UK) LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0411';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0411','CNP ASSURANCES','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0414';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0414','UBS INTERNATIONAL LIFE LIMITED','','35316094501','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0415';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0415','PRISMALIFE AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0416';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0416','UNIQA OSTERREICH VERSICHERUNGEN AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0417';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0417','AXA ASSURANCES LUXEMBOURG S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0418';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0418','LIBERTY MUTUAL INSURANCE EUROPE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0419';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0419','ALLIANZ GLOBAL CORPORATE # SPECIALTY AG.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0420';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0420','HANSARD EUROPE DAC.','','2781488','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0421';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0421','AXA LEBENSVERSICHERUNG AG.','','1803556622','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0422';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0422','ELECTROLUX FORSAKRINGSAKTIEBOLAG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0424';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0424','ROYAL # SUN ALLIANCE INSURANCE PLC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0426';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0426','INTERNATIONAL CREDIT MUTUEL LIFE S.A','','352 2720411','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0428';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0428','ALLIANZ GLOBAL CORPORATE # SPECIALTY AG(SUC.REINO UNIDO)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0429';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0429','ASSURANCES DU CREDIT MUTUEL IARD S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0430';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0430','CNA INSURANCE COMPANY LIMITED (SUC.FRANCIA)','','2077433800','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0431';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0431','CNA INSURANCE COMPANY LIMITED (SUC.ALEMANIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0432';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0432','CNA INSURANCE COMPANY LIMITED(SUC.PAISES BAJOS)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0433';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0433','CNA INSURANCE COMPANY LIMITED(SUC.DINAMARCA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0434';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0434','SOCIETE D*ASSURANCES GENERALES APPLIQUEES (SAGA)DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0438';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0438','CACI LIFE DAC','','35314189750','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0442';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0442','NEW TECHNOLOGY INSURANCE','','35316324000','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0443';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0443','THE OCEAN MARINE INSURANCE COMPANY LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0446';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0446','BRIT INSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0448';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0448','AMTRUST INTERNATIONAL UNDERWRITERS DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0449';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0449','CNP IAM','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0453';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0453','AGPM VIE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0455';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0455','PETRUS INSURANCE COMPANY LIMITED(GIBRALTAR)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0458';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0458','AEGON IRELAND PLC','','353(0)16738840','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0460';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0460','ARAG ALLGEMEINE VERSICHERUNGS-AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0462';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0462','SYNTONIA INSURANCE AG.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0463';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0463','EXETER FRIENDLY SOCIETY LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0464';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0464','ALLIANZ RISK TRANSFER N.V.','','31(20)6268149','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0465';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0465','CACI NON-LIFE DAC','','35316039649','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0466';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0466','GENERALI PANEUROPE LTD','','353469060266','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0467';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0467','ACE EUROPEAN GROUP LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0468';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0468','CIGNA EUROPE INSURANCE COMPANY S.A.-NV','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0469';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0469','ARCH INSURANCE COMPANY (EUROPE)LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0472';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0472','VOLVO GROUP INSURANCE FORSAKRINGSAKTIEBOLAG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0473';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0473','HOLMEN FORSAKRING AB','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0474';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0474','BUPA INSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0475';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0475','AVIVA LIFE # PENSIONS UK LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0476';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0476','AVIVA ANNUITY UK LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0477';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0477','GENERAL ACCIDENT LIFE ASSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0478';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0478','AXA CORPORATE SOLUTIONS ASSURANCE (SUC.ALEMANIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0479';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0479','SWISS LIFE(LIECHTENSTEIN) AG,VADUZ','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0480';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0480','NOBLE INSURANCE COMPANY DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0481';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0481','COMPAGNIE FRANCAISE D*ASSURANCE POUR LE COMMERCE EXTERIEUR(SUC.REINO UNIDO)COFACE','N0065575C','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0484';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0484','ASPEN INSURANCE UK LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0485';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0485','HARTFORD LIFE LIMITED','','35318830300','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0486';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0486','HDI GLOBAL SE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0491';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0491','ALLIED WORLD ASSURANCE COMPANY (EUROPE)LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0492';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0492','MITSUI SUMITOMO INSURANCE (EUROPE)LIMITEDSUCURSAL ALEMANIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0494';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0494','NOKATUS INSURANCE COMPANY DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0495';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0495','WIENER STADTISCHE VERSICHERUNG AG VIENNA INSURANCE GROUP','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0496';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0496','SWISS LIFE ASSURANCE(FRANCIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0499';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0499','FOYER INTERNATIONAL S.A','','352 43743379','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0500';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0500','COVEA RISKS','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0501';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0501','ZURICH INSURANCE PLC.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0502';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0502','AGPM ASSURANCES','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0505';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0505','ALLIANZ POJIST*OVNA,A.S','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0506';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0506','SOLID FORSAKRINGSAKTIEBOLAG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0507';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0507','CAHIR INSURANCE LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0509';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0509','TELEFONICA INSURANCE S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0527';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0527','VHV ALLGEMINE VERSICHERUNG A.G','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0530';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0530','CLARIANT INSURANCE AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0533';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0533','BPI VIDA E PENSOES- COMPANHIA DE SEGUROS S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0535';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0535','TRADEWISE INSURANCE COMPANY LIMITED(GIBRALTAR)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0536';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0536','AIOI NISSAY DOWA INSURANCE COMPANY OF EUROPE LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0539';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0539','ALLIANZ HUNGARIA BIZTOSITO R.T','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0541';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0541','AMLIN EUROPE N.V SUCURSAL EN BELGICA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0542';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0542','BASLER SECURITAS VERSICHERUNGS-AKTIENGESELLSCHAFT','','(0421)308589653','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0543';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0543','ALLIANZ ELEMENTAR LEBENSVERSICHERUNG AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0544';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0544','ELECTRIC INSURANCE IRELAND LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0546';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0546','GERLING POLSKA TOWARZYSTWO UBEZPIECZEN S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0547';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0547','YARA INSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0548';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0548','HSBC VIE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0551';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0551','LE SPHINX ASSURANCES LUXEMBOURG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0552';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0552','NEMI FORSIKRING ASA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0553';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0553','CATLIN INSURANCE COMPANY(UK)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0554';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0554','PRIVATE INSURER S.A','','32(0)26761860','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0557';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0557','INTER PARTNER ASSISTANCE (SUCURSAL EN FRANCIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0558';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0558','AMTRUST EUROPE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0560';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0560','ENDURANCE WORLDWIDE INSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0561';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0561','INTER PARTNER ASSISTANCE (SUCURSAL ALEMANIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0564';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0564','MEDICAL INSURANCE COMPANY DAC.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0565';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0565','MULTI RISK INDEMNITY COMPANY LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0566';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0566','FALCON INSURANCE LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0567';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0567','WAGRAM INSURANCE COMPANY LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0571';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0571','COVEA FLEET','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0572';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0572','ALLIANZ ELEMENTAR VERSICHERUNG AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0574';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0574','CANADA LIFE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0575';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0575','GOTHAER ALLGEMEINE VERSICHERUNG AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0576';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0576','NEUFLIZE VIE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0577';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0577','SKANDIA LEBEN AG,LEBENSVERSICHERUNGS-AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0578';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0578','MANNHEIMER VERSICHERUNG AKTIENGESELLSCHAFT.','','6214574791','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0579';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0579','KBC VERZEKERINGEN','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0580';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0580','INFRASSURE LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0581';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0581','GENERALI ITALIA S.P.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0585';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0585','PARTNER RE IRELAND INSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0588';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0588','FIRST TITLE INSURANCE PLC','','2078323100','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0589';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0589','TRAVELERS INSURANCE COMPANY LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0590';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0590','LANCASHIRE INSURANCE COMPANY (UK)LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0591';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0591','HUGO INSURANCE S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0592';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0592','ZURICH INSURANCE PLC (SUC.REINO UNIDO)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0593';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0593','ZURICH INSURANCE PLC.(SUC.FRANCIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0594';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0594','ZURICH INSURANCE PLC.(SUC.SUECIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0595';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0595','ZURICH INSURANCE PLC.(SUC.FINLANDIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0596';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0596','SARA ASSICURAZIONI S.P.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0597';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0597','THE UNITED KINGDOM MUTUAL STEAM SHIP ASSOCIATION (EUROPE) LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0598';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0598','VATRYGGINGAFELAG ISLANDS HF','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0599';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0599','SIRIUS INTERNATIONAL INSURANCE CORPORATION (PUBL)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0600';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0600','CHARTIS EXCESS LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0602';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0602','CODAN FORSIKRING A/S','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0603';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0603','ENI INSURANCE DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0604';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0604','ASSURANT GENERAL INSURANCE COMPANY LIMITED','','8701526009','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0605';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0605','ASSURANT LIFE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0606';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0606','HELVETIA SCHWEIZERISCHE VERSICHERUNGSGESELLSCHAFT IN LIECHTENSTEIN AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0607';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0607','ZURICH INSURANCE PLC.(SUC.ITALIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0608';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0608','ZURICH INSURANCE PLC.(SUC.PAISES BAJOS)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0609';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0609','ZURICH INSURANCE PLC (SUC.BELGICA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0610';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0610','COMPAGNIA ITALIANA DI PREVIDENZA ASSICURAZIONI E RIASSICURAZIONI(ITALIANA ASSICURAZIONI)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0612';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0612','CREDIMUNDI S.A/NV','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0613';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0613','QBE INSURANCE (EUROPE) LIMITED SUC.ALEMANIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0615';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0615','STARSTONE INSURANCE EUROPE) AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0617';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0617','ACE EUROPE LIFE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0619';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0619','MAIDEN LIFE AB','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0620';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0620','QBE INSURANCE (EUROPE) LIMITED SUC.ESTONIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0622';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0622','PRCG POUEY RENSEIGNMENT COMMERCIAL GARANTI SA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0623';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0623','GRESHAM INSURANCE COMPANY LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0624';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0624','GAI INTERNATIONAL INSURANCE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0625';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0625','QBE INSURANCE (EUROPE) LIMITED (SUC.BULGARIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0627';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0627','N.V HAGELUNIE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0628';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0628','CG CAR-GARANTIE VERSICHERUNGS AKTIENGESELLSCHAFT.','','497614548-0','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0629';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0629','QBE INSURANCE (EUROPE) LIMITED (SUC.FRANCIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0630';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0630','ALLIANZ GLOBAL CORPORATE # SPECIALTY AG SUC FRANCIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0631';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0631','PTI INSURANCE COMPANY LIMITED(GIBRALTAR)','','35076047','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0633';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0633','ROEMINCK INSURANCE N.V','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0634';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0634','CFDP ASSURANCES','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0635';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0635','THE PRUDENTIAL ASSURANCE COMPANY LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0636';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0636','WINDSOR LIFE ASSURANCE COMPANY LIMITED','','8708873333','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0637';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0637','GABLE INSURANCE AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0638';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0638','KINGFISHER INSURANCE DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0639';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0639','INSURANCE COMPANY EUROINS AD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0640';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0640','VISHAY INSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0641';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0641','CAISSE DE REASSURANCE MUTUELLE AGRICOLE DU CENTRE MANCHE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0644';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0644','BERKSHIRE HATHAWAY INTERNATIONAL INSURANCE COMPANY','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0645';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0645','LA PARISIENNE ASSURANCES','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0646';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0646','UNITED KINGDOM FREIGHT DEMURRAGE AND DEFENCE ASSOCIATION','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0647';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0647','TWINCAP FORSAKRINGS AB','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0648';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0648','ST.JAMES PLACE INTERNATIONAL PLC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0650';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0650','TELIASONERA FORSAKRING AB','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0653';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0653','JUSTITIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0654';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0654','TRANS-EUROPE ASSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0655';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0655','POHJOLA INSURANCE LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0656';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0656','LEMMA EUROPE INSURANCE COMPANY LIMITED(GIBRALTAR)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0658';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0658','FOYER ASSURANCES S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0660';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0660','AETNA HEALTH INSURANCE COMPANY OF EUROPE DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0662';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0662','STEWART TITLE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0663';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0663','ESPRIT INSURANCE DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0664';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0664','CREDIT AGRICOLE RISK INSURANCE S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0667';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0667','ALLIANZ SOCIETA PER AZIONI (S.P.A)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0669';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0669','INTERNATIONAL DIVING ASSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0671';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0671','METLIFE EUROPE INSURANCE DESIGNATED ACTIVITY COMPANY','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0672';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0672','LIVERPOOL VICTORIA FRIENDLY SOCIETY LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0673';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0673','ERGON INSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0674';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0674','CNA INSURANCE COMPANY LIMITED(SUC.ITALIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0675';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0675','GROUPAMA RHONE ALPES AUVERGNE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0676';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0676','CBL INSURANCE EUROPE DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0678';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0678','INTER PARTNER ASSISTANCE SUC.IRLANDA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0679';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0679','CNA INSURANCE COMPANY LIMITED(SUC.BELGICA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0680';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0680','AVIABEL S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0681';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0681','PHARMA INTERNATIONAL INSURANCE DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0682';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0682','EUROPEISKA FORSAKRINGSAKTIEBOLAGET','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0683';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0683','VISENTA FORSAKRINGSAKTIEBOLAG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0685';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0685','NISSAN INTERNATIONAL INSURANCE LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0687';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0687','ZURICH INSURANCE PLC, SUC.DINAMARCA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0688';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0688','ZURICH INSURANCE PLC.SUC.NORUEGA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0690';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0690','ELECTRO ASSURANCES S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0691';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0691','EUROPAISCHE REISEVERSICHERUNG AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0692';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0692','HELVETIA VERSICHERUNGS-AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0693';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0693','AXA BELGIUM, S.A.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0700';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0700','PEMBROKE INTERNATIONAL INSURANCE COMPANY LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0701';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0701','NEWLINE INSURANCE COMPANY LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0702';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0702','HDI VERSICHERUNG AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0703';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0703','RCI INSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0704';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0704','RCI LIFE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0706';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0706','PALLAS VERSICHERUNG AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0708';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0708','BALOISE VIE LUXEMBOURG S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0709';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0709','EULER HERMES FRANCE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0710';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0710','CODAN FORSIKRING A/S SUC.NORUEGA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0714';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0714','CHUBB INSURANCE COMPANY OF EUROPE SE (REINO UNIDO)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0715';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0715','CHUBB INSURANCE COMPANY OF EUROPE SE (SUC.AUSTRIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0717';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0717','CHUBB INSURANCE COMPANY OF EUROPE SE SUC.DINAMARCA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0718';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0718','CHUBB INSURANCE COMPANY OF EUROPE SE SUC.FRANCIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0719';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0719','CHUBB INSURANCE COMPANY OF EUROPE SE SUC.ALEMANIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0720';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0720','CHUBB INSURANCE COMPANY OF EUROPE SE SUC.IRLANDA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0721';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0721','CHUBB INSURANCE COMPANY OF EUROPE SE SUC.ITALIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0722';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0722','CHUBB INSURANCE COMPANY OF EUROPE SE SUC.PAISES BAJOS','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0723';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0723','CHUBB INSURANCE COMPANY OF EUROPE SE SUC.SUECIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0724';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0724','AIG EUROPE S.A SUC.R.CHECA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0725';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0725','AIG EUROPE LIMITED SUC.ESLOVAQUIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0726';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0726','AIG EUROPE LIMITED SUC.HUNGRIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0727';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0727','INTER PARTNER ASSISTANCE (SUC.REINO UNIDO)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0728';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0728','TOWARZYSTWO UBEZPIECZEN EULER HERMES S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0729';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0729','AIG EUROPE LIMITED SUC.POLONIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0730';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0730','NORWEGIAN HULL CLUB-GJENSIDIG ASSURANSEFORENING','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0731';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0731','AVIVA ITALIA S.P.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0732';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0732','NRV NEUE RECHTSSCHUTZ-VERSICHERUNGSGESELLSCHAFT AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0733';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0733','GARANT VERSICHERUNGS-AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0734';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0734','AXA FRANCE VIE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0736';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0736','ALLIANZ GLOBAL CORPORATE # SPECIALTY AG (SUC.DINAMARCA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0737';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0737','ALLIANZ GLOBAL CORPORATE # SPECIALTY AG SUC.AUSTRIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0738';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0738','ALLIANZ GLOBAL CORPORATE # SPECIALTY AG SUC.ITALIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0740';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0740','CARDIF ASSURANCES RISQUES DIVERS','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0743';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0743','ETHIAS S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0745';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0745','CAISSE REGIONALE D*AASURANCES MUTUELLES AGRICOLES PARIS VAL DE LOIRE(GROUPAMA PARIS VAL DE LOIRE)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0746';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0746','KRAVAG-LOGISTC VERSICHERUNGS-AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0747';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0747','CNA INSURANCE COMPANY LIMITED(SUC.SUECIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0749';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0749','SACE BT S.P.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0750';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0750','AXA ART VERSICHERUNG AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0751';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0751','AXA ART VERSICHERUNG AG SUC.ITALIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0752';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0752','AXA ART VERSICHERUNG AG SUC.FRANCIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0753';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0753','AXA ART VERSICHERUNG AG SUC.BELGICA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0754';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0754','AXA ART VERSICHERUNG AG SUC PAISES BAJOS','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0755';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0755','BALCIA INSURANCE SE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0756';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0756','STARSTONE INSURANCE PLC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0757';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0757','HUMANIS PREVOYANCE','','144894432','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0758';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0758','ALPHA INSURANCE A/S','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0759';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0759','E-CIE VIE S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0760';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0760','MAPFRE SEGUROS GERAIS S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0761';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0761','PSA INSURANCE LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0762';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0762','ATERFORSAKRINGSAKTIEBOLAGET SKF(SKF REINSURANCE COMPANY LTD)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0763';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0763','ZURICH INSURANCE PLC SUC.PORTUGAL','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0764';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0764','PSA LIFE INSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0765';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0765','AIG EUROPE SUC.PAISES BAJOS','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0766';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0766','HUBENER VERSICHERUNGS AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0767';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0767','GLOBALITY S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0768';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0768','LANDSCHAFTLICHE BRANDKASSE HANNOVER','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0769';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0769','ERICSSON INSURANCE (FORSAKRING) AB','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0770';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0770','WHITE ROCK INSURANCE (EUROPE) PCC LIMITED MALTA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0771';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0771','SWISS LIFE ASSURANCE SOLUTIONS SA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0773';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0773','SWISS RE INTERNATIONAL S.E','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0774';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0774','TAPIOLA GENERAL MUTUAL INSURANCE COMPANY','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0775';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0775','CIGNA LIFE INSURANCE COMPANY OF EUROPE S.A(SUC.ITALIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0776';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0776','CIGNA LIFE INSURANCE COMPANY OF EUROPE, S.A.(SUC.REINO UNIDO)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0777';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0777','CIGNA LIFE INSURANCE COMPANY OF EUROPE SA(SUC.ALEMANIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0778';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0778','ONDERLINGE VERZEKERING-MAATSCHAPPIJ NOORD-NEDERLANDSCHE P#I CLUB U.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0779';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0779','SEAMAIR INSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0781';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0781','DONAU VERSICHERUNG AG VIENNA GROUP','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0784';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0784','BAYERISCHER VERSICHERUNGSVERBAND','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0785';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0785','WESTFALISCHE PROVINZIAL VERSICHERUNG AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0786';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0786','HDI VERSICHERUNG AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0787';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0787','HDI-GERLING FIRMEN UND PRIVAT VERSICHERUNG AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0788';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0788','EUROVITA ASSICURAZIONI S.P.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0790';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0790','GAN ASSURANCES','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0791';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0791','SV SPARKASSENVERSICHERUNG GEBAUDEVERSICHERUNG AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0792';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0792','ZURICH INSURANCE PLC SUC. ALEMANIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0794';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0794','FORSIKRINGSSELSKABET PRIVATSIKRING A/S','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0796';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0796','W.R.BERKLEY INSURANCE (EUROPE) LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0797';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0797','AXA ART INSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0798';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0798','PAMIA LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0800';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0800','THE GRIFFIN INSURANCE ASSOCIATION LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0801';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0801','MINSTER INSURANCE COMPANY LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0802';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0802','HCC INTERNATIONAL INSURANCE COMPANY PLC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0803';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0803','AETNA INSURANCE COMPANY LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0807';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0807','UNION REISEVERSICHERUNG AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0808';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0808','UNION REISEVERSICHERUNG AG SUC.REINO UNIDO','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0816';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0816','SOCIETE MUTUELLE DU BATIMENT ET DES TRAVAUX PUBLICS(SMABTP)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0819';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0819','SUN INSURANCE OFFICE LIMITED SUC.ITALIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0820';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0820','ROYAL # SUN ALLIANCE INSURANCE(GLOBAL)LTD SUC.PAISES BAJOS','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0821';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0821','TRYG FORSIKRING A/S SUC.SUECIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0822';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0822','TRYG FORSIKRING A/S SUC.NORUEGA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0823';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0823','ALLIANZ GLOBAL CORPORATE # SPECIALTY AG(ALEMANIA)SUC PAISES BAJOS','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0824';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0824','ALLIANZ GLOBAL CORPORATE # SPECIALTY AG SUC.BELGICA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0826';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0826','SAARLAND FEUERVERSICHERUNG AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0827';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0827','W.R. BERKLEY INSURANCE (EUROPE) LIMITED SUC.NORUEGA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0828';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0828','ASSURANCES DU CREDIT MUTUEL VIE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0829';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0829','VIENNA INSURANCE GROUP AG WIENER VERSICHERUNG GRUPPE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0830';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0830','ACHMEA SCHADEVERZEKERINGEN N.V','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0831';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0831','SURESTONE INSURANCE DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0832';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0832','ARISCOM COMPAGNIA DI ASSICURAZIONI S.P.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0833';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0833','AXA INSURANCE UK PLC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0834';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0834','QBE INSURANCE (EUROPE) LIMITED SUC.DINAMARCA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0836';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0836','LANSFORSAKRINGAR SAK FORSAKRINGSAKTIEBOLAG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0837';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0837','THE STEAMSHIP MUTUAL UNDERWRITING ASSOCIATION LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0838';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0838','WALDENBURGER VERSICHERUNG AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0839';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0839','CAISSE REGIONALE D` ASSURANCES MUTUELLES AGRICOLES BRETAGNE PAYS DE LOIRE(groupama Loire-Bretagne)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0840';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0840','CAISSE REGIONALE D*ASSURANCES MUTUELLES AGRICOLES D*OC(GROUPAMA D*OC)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0841';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0841','SWISSLIFE PREVOYANCE # SANTE S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0842';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0842','WEALTH-ASSURANCE AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0843';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0843','IRONSHORE EUROPE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0845';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0845','IMA ASSURANCES','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0846';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0846','ELITE INSURANCE COMPANY LIMITED GIBRALTAR','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0847';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0847','CARMA SOCIETE ANONYME','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0848';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0848','CARMA VIE S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0849';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0849','GREAT AMERICAN INTERNATIONAL INSURANCE DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0851';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0851','FEUERSOZIETAT BERLIN BRANDENBURG VERSICHERUNG AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0853';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0853','ORKLA INSURANCE COMPANY DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0856';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0856','BAYERISCHE LANDESBRANDVERSICHERUNG AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0857';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0857','EUROPEAN RISK INSURANCE COMPANY HF','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0859';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0859','DARAG DEUTSCHE VERSICHERUNGS UND RUCKVERSICHERUNGS-AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0861';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0861','THE MARINE INSURANCE COMPANY LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0862';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0862','DEN NORSKE KRIGSFORSIKRING FOR SKIB GJENSIDIG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0863';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0863','PRINCIPLE FORSAKRINGS AB','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0864';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0864','PAN INSURANCE DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0865';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0865','ACIPIL LIFE S.A (LUXEMBURGO)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0866';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0866','HANSE-MARINE VERSICHERUNG AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0867';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0867','COMPANIA DE ASIGURARI-REASIGURARI EXIM ROMANIA(CARE-ROMANIA)S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0868';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0868','DSV INSURANCE A/S','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0869';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0869','ZURICH LIFE ASSURANCE PLC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0870';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0870','ACE EUROPEAN GROUP LIMITED SUC.PORTUGAL','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0872';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0872','ROYAL # SUN ALLIANCE INSURANCE PLC(SUC.ALEMANIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0873';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0873','ROYAL # SUN ALLIANCE INSURANCE PLC(SUC.ITALIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0874';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0874','ROYAL # SUN ALLIANCE INSURANCE PLC(SUC.FRANCIA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0875';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0875','ROYAL # SUN ALLIANCE INSURANCE PLC(SUC.PAISES BAJOS)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0876';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0876','SAMSUNG FIRE # MARINE INSURANCE COMPANY OF EUROPE LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0879';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0879','MSIG INSURANCE EUROPE AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0880';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0880','HANDELSBANKEN LIV FORSAKRINGSAKTIEBOLAG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0881';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0881','QUANTUM LEBEN AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0882';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0882','BALOISE BELGIUM NV/SA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0883';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0883','ONIX ASIGURARI S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0884';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0884','AMTRUST INSURANCE LUXEMBOURG S.A(AILSA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0885';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0885','UNIQA VERSICHERUNG AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0886';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0886','VOLKSWAGEN INSURANCE COMPANY DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0887';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0887','CREDIT LIFE INTERNATIONAL VERSICHERUNG AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0888';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0888','HELVETIA ASSURANCES S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0890';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0890','GREENVAL INSURANCE COMPANY DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0891';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0891','EUROP ASSISTANCE SUC.IRLANDA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0892';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0892','CNP SANTANDER INSURANCE EUROPE DESIGANTED ACTIVITY COMPANY','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0893';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0893','CNP SANTANDER INSURANCE LIFE DESIGNATED ACTIVITY COMPANY','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0894';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0894','FAMILY PROTECT LIMITED COMPANY','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0895';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0895','VOLKSWAGEN VERSICHERUNG AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0897';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0897','GUARANTEE PROTECTION INSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0898';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0898','GARTENBAU-VERSICHERUNG VVAG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0900';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0900','ACE EUROPEAN GROUP LIMITED SUC.ALEMANIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0901';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0901','ACE EUROPEAN GROUP LIMITED SUC.FRANCIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0902';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0902','ACE EUROPEAN GROUP LIMITED SUC.ITALIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0903';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0903','RSIF INTERNATIONAL DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0904';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0904','AMLIN INSURANCE SE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0905';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0905','EAST-WEST ASSEKURANZ AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0906';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0906','MUTUELLE ASSURANCE DES COMMERCANTS ET INDUSTRIELS DE FRANCE (MACIF)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0907';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0907','COFACE S.A SUC.PORTUGAL','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0908';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0908','ARIA INSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0909';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0909','COFACE SA SUC.ALEMANIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0910';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0910','COFACE SA SUC.ITALIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0911';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0911','STM LIFE ASSURANCE PCC PLC (GIBRALTAR)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0912';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0912','ROYAL # SUN ALLIANCE INSURANCE PLC(SUC.BELGICA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0913';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0913','INTER PARTNER ASSISTANCE SA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0914';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0914','ERGO DIREKT VERSICHERUNG AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0915';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0915','INTEGRALIFE UK LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0916';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0916','COFACE SA SUC.AUSTRIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0917';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0917','BUPA INSURANCE LIMITED(SUC.DINAMARCA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0918';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0918','RHEINLAND VERSICHERUNGS AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0919';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0919','CREDIT LIFE AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0920';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0920','AXERIA IARD LTD COMPANY','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0922';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0922','PROVINZIAL RHEINLAND VERSICHERUNG AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0923';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0923','ARGOGLOBAL SE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0924';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0924','FWU LIFE INSURANCE LUX S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0926';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0926','ALLIANZ PLC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0927';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0927','AWP HEALTH # LIFE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0928';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0928','ALLIANZ WORLDWIDE CARE SA SUC IRLANDA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0930';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0930','ALLIANZ BENELUX SA/NV','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0932';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0932','NN LIFE LUXEMBOURG S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0933';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0933','TOWARZYSTWO UBEZPIECZEN I REASEKURACJI ALLIANZ POLSKA S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0934';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0934','AXA VERSICHERUNG AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0935';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0935','INTERNATIONAL INSURANCE COMPANY OF HANNOVER SE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0936';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0936','ONEY INSURANCE (PCC) LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0937';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0937','ONEY LIFE (PCC) LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0938';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0938','HIGHDOME PCC LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0939';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0939','INTESA SANPAOLO LIFE DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0940';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0940','PINNACLE INSURANCE PLC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0941';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0941','SWISSPARTNERS VERSICHRUNG AG SUC.AUSTRIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0942';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0942','MELES INSURANCE A/S','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0944';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0944','SOCIETE HOSPITALIERE D* ASSURANCES MUTUELLES(SHAM)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0945';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0945','S.C. ABC ASIGURARI-REASIGURARI S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0946';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0946','BD24 BERLIN DIREKT VERSICHERUNG AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0952';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0952','PRUDENCE CREOLE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0953';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0953','QUDOS INSURANCE A/S','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0954';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0954','BULSTRAD LIFE VIENNA INSURANCE GROUP JSC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0955';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0955','AXA ASSICURAZIONI S.P.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0956';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0956','ARKEMA INSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0957';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0957','CHUBB BERMUDA INTERNATIONAL INSURANCE(IRELAND)DAC SUC.R.UNIDO','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0958';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0958','THE CARE INSURANCE COMPANY LIMITED(GIBRALTAR)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0959';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0959','AVIVA INSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0960';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0960','EULER HERMESEUROPE SA /NV SUC FRANCIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0970';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0970','ACASTA EUROPEAN INSURANCE COMPANY LIMITED(GIBRALTAR)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0971';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0971','NAUTILUS INDEMNITY (EUROPE) DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0972';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0972','INTERNATIONAL INSURANCE COMPANY OF HANNOVER SE SUC.REINO UNIDO','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0973';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0973','INTRENATIONAL INSURANCE COMPANY OF HANNOVER SE SUC.SUECIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0974';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0974','VITAL BLUE INSURANCE DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0975';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0975','MMA IARD SA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0976';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0976','PSA LIFE INSUANCE EUROPE LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0977';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0977','PSA INSURANCE EUROPE LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0978';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0978','THE WEST OF ENGLAND SHIP OWNERS* MUTUAL INSURANCE ASSOCIATION (LUXEMBOURG)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0979';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0979','GENERALI COMPANHIA DE SEGUROS S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0980';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0980','GARD MARINE # ENERGY INSURANCE (EUROPE)AS','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0981';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0981','HOLMIA LIVFORSAKRING AB','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0982';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0982','INTER ALLGEMEINE VERSICHERUNG AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0983';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0983','CAISSE REGIONALE D*ASSURANCES MUTUELLES AGRICOLES MEDITERRANEE(GROUPAMA MEDITERRANEE)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0984';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0984','GREENSTARS BNP PARIBAS S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0985';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0985','TVM VERZEKERINGEN N.V','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0986';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0986','ALLIANZ LEBENSVERSICHERUNGS AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0987';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0987','FONDS DE GARANTIE VOYAGES A.A.M.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0988';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0988','GENERALI ZAVAROVALNICA,D.D COMPNY LIMITED BY SHARE CAPITAL','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0990';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0990','ALTE LEIPZIGER VERSICHERUNG AKTTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0991';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0991','EULER HERMES EUROPE SA/NV SUC ALEMANIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0992';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0992','OLD MUTUAL WEALTH LIFE # PENSIONS LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0993';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0993','NATIONAL GENERAL LIFE INSURANCE EUROPE S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0994';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0994','NATIONAL GENERAL INSURANCE LUXEMBOURG S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0995';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0995','AFI ESCA LUXEMBOURG S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0996';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0996','IPTIQ INSURANCE S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0997';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0997','IRISH LIFE ASSURANCE COMPANY PLC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L0998';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L0998','HSBC LIFE ASSURANCE (MALTA) LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1000';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1000','SALVA KINDLUSTUSE AS','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1001';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1001','KUPEG UVEROVA POJIST*OVNA A.S','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1002';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1002','VOLKSWAGEN VERSICHERUNG AKTIENGESELLSCHAFT SUC FRANCIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1003';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1003','MOTORS INSURANCE COMPANY LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1004';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1004','UNITED KINGDOM MUTUAL WAR RISKS ASSOCIATION LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1005';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1005','TRANSRE LONDON LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1006';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1006','ASTRENSKA INSURANCE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1007';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1007','CHINA TAIPING INSURANCE (UK) CO.LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1008';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1008','QIC EUROPE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1010';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1010','IPTIQ LIFE S.A SUC ALEMANIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1011';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1011','IPTIQ LIFE S.A SUC PAISES BAJOS','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1012';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1012','IPTIQ LIFE S.A SUC R.U','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1013';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1013','IPTIQ LIFE S.A SUC IRLANDA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1014';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1014','HDI GLOBAL SE SUC BELGICA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1015';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1015','HDI GLOBAL SE SUC FRANCIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1016';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1016','HDI GLOBAL SE AG SUC GRECIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1017';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1017','HDI GLOBAL SE SUC IRLANDA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1018';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1018','HDI GLOBAL SE SUC ITALIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1019';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1019','HDI GLOBAL SE SUC PAISES BAJOS','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1020';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1020','HDI GLOBAL SE SUC NORUEGA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1021';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1021','HDI GLOBAL SE SUC R.UNIDO','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1022';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1022','KNAPTON INSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1023';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1023','ISTITUTO TRENTINO ALTO ADIGE PER ASSICURAZIONI SOCIETA MUTUA DI ASSICURAZIONI ITAS*S','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1024';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1024','COVEA INSURANCE PLC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1025';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1025','NATIXIS LIFE S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1026';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1026','ROTHESAY LIFE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1027';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1027','FRIENDS LIFE AND PENSIONS LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1029';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1029','SCOTTISH WIDOWS LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1030';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1030','AUGURA LIFE IRELAND LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1031';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1031','CROATIA OSIGURANJE D.D.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1032';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1032','SIKURA LEBEN AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1033';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1033','NORDISK MARINFORSAKRING AB','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1034';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1034','SCOTTISH EQUITABLE PLC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1035';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1035','DUTCH SHIPPING DEFENCE N.V','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1036';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1036','INSER AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1037';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1037','ADVENT INSURANCE PCC LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1038';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1038','ALLIANZ GLOBAL LIFE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1046';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1046','FIDELIS UNDERWRITING LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1047';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1047','W.R. BERKLEY EUROPE AG SUC.ALEMANIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1048';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1048','ACHMEA ZORGVERZEKERINGEN N.V.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1049';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1049','AVERO ACHMEA ZORGVERZEKERINEN N.V','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1050';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1050','ZILVEREN KRUIS ZORGVERZEKERINGEN N.V','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1051';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1051','OZF ZORGVERZEKERINGEN N.V.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1052';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1052','INTERPOLIS ZORGVERZEKERINGEN N.V.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1053';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1053','ZILVEREN KRUIS ZIEKTEKOSTENVERZEKERINGEN N.V.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1054';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1054','UNION TECHNIQUE RESSOURCES MUTUELLES ASSISTANCE (RMA)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1055';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1055','CNP LUXEMBOURG S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1056';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1056','ASR BASIS ZIEKTEKOSTENVERZEKERINGEN N.V','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1057';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1057','ASR AANVULLENDE ZIEKTEKOSTENVERZEKERINGEN N.V.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1058';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1058','MENZIS N.V.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1059';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1059','MENZIS ZORGVERZEKERAAR N.V','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1060';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1060','ANDERZORG N.V.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1061';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1061','AZIVO N.V.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1062';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1062','ADAC-SCHUTZBRIEF VERSICHERUNGS-AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1063';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1063','ALLIANZ NEDERLAND LEVENSVERZEKERING N.V','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1064';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1064','DE FRIESLAND PARTICULIERE ZIEKTEKOSTENVERZEKERINGEN N.V.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1065';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1065','DE FRIESLAND ZORGVERZEKERAAR N.V.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1066';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1066','FBTO ZORGVERZEKERINGEN N.V.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1067';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1067','CASUALTY # GENERAL INSURANCE COMPANY LIMITED(GIBRALTAR)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1068';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1068','DELTA LLOYD ZORGVERZEKERING NV','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1069';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1069','OHRA ZIEKTEKOSTENVERZEKERINGEN N.V.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1070';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1070','OHRA ZORGVERZEKERINGEN N.V.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1071';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1071','OWM CZ GROEP AANVULLENDE VERZEKERING ZORGVERZEKERAAR U.A.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1072';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1072','OWM CZ GROEP ZORGVERZEKERAAR U.A.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1073';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1073','ENO ZORGVERZEKERAAR N.V.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1074';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1074','ENO AAVULLENDE VERZEKERINGEN N.V.','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1075';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1075','SWISS LIFE ASSURANCES DE BIENS LIMITED COMPANY','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1076';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1076','SWISS LIFE PRODUCTS (LUXEMBOURG)S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1077';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1077','THE NEW INDIA ASSURANCE COMPANY LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1078';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1078','AWP P#C SUC PAISES BAJOS','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1079';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1079','CIG PANNONIA ELSO MAGYAR ATALANOS BIZTOSITO ZRT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1080';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1080','ORNUA INSURANCE DAC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1081';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1081','WERTGARANTIE AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1082';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1082','RHENAS INSURANCE LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1083';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1083','AXA TOWARZYSTWO UBEZPIECZEN I REASEKURACJI SPOLKA AKCYJNA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1084';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1084','COLONNADE INSURANCE S.A SUC.HUNGRIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1085';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1085','COLONNADE INSURANCE S.A SUC.ESLOVAQUIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1086';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1086','COLONNADE INSURANCE S.A. SUC R.CHECA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1087';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1087','HILLWOOD LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1088';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1088','ASR LEVENSVERZEKERING NV','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1089';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1089','ALM.BRAND FORSIKRING A/S','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1090';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1090','FINTERLIFE LEBENSVERSICHERUNGS-AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1091';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1091','KUKE KORPORACJA UBEZPIECZEN KREDYTOW EKSPORTOWYCH SPOLKA AKCJNA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1092';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1092','GENERALI HELLAS S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1093';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1093','INTERAMERICAN PROPERTY # CASUALTY INSURANCE CO S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1094';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1094','KOOPERATIVA POJIST*OVNA A.S VIENNA INSURANCE GROUP','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1095';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1095','SCA FORSAKRINGSAKTIEBOLAG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1096';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1096','PARTNERSHIP LIFE ASSURANCE COMPANY LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1097';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1097','BLACKROCK LIFE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1100';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1100','ZENITH INSURANCE PLC(GIBRALTAR)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1101';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1101','EIFLOW INSURANCE LIMITED(GIBRALTAR)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1102';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1102','GROUPAMA S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1103';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1103','ALGEMENE LEVENSHERVERZERING','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1105';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1105','OOM SCHADEVERZEKERING NV','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1106';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1106','CERTASIG-SOCIETATE DE ASIGURARE SI REASIGURARE S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1107';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1107','DANICA LIFE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1108';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1108','ERGO INSURANCE SE','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1109';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1109','ERGO INSURANCE SE SUC.LITUANIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1111';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1111','COFACE SA SUC.RUMANIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1112';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1112','COFACE SA SUC.R.CHECA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1113';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1113','COFACE SA SUC.LETONIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1115';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1115','COFACE SA SUC.LITUANIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1118';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1118','VAV VERSICHERUNGS-AKTIENGESELLSCHAFT','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1119';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1119','EUROMEX NV','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1120';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1120','COFACE SA SUC.POLONIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1121';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1121','COFACE SA SUC. DINAMARCA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1122';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1122','COFACE SA SUC. PAISES BAJOS','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1123';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1123','COFACE SA SUC.SUECIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1124';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1124','INTERASCO SOCIETE ANONYME GENERAL INSURANCES AEGA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1126';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1126','ABARCA COMPANHIA DE SEGUROS, S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1127';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1127','GNB-COMPANHIA DE SEGUROS VIDA, S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1128';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1128','VICTORIA SEGUROS, S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1129';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1129','TENECOM LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1130';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1130','PRUDENTIAL PENSIONS LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1131';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1131','AWP P#C SUC BELGICA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1133';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1133','METLIFE INSURANCE LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1134';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1134','HDI-GERLING RECHTSSCHUTZ VERSICHERUNG AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1135';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1135','BULGARIAN EXPORT INSURANCE AGENCY /BAEZ/ EAD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1136';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1136','ALLIANZ HUNGARIA BIZTOSITO ZARTKORUEN MUKODO RESZVENYTARSASAG SUC.ESLOVENIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1138';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1138','ASSOCIATIONS MUTUELLES LE CONSERVATEUR','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1139';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1139','LONDON # COLONIAL ASSURANCE PLC(GIBRALTAR)','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1140';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1140','VICTORIA SEGUROS DE VIDA, S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1141';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1141','KLPP INSURANCE # REINSURANCE COMPANY LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1142';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1142','AMLIN INSURANCE SE SUC.BELGICA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1143';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1143','AMLIN INSURANCE SE SUC.FRANCIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1144';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1144','AMLIN INSURANCE SE SUC.ALEMANIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1145';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1145','AMLIN INSURANCE SE SUC.PAISES BAJOS','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1146';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1146','MONARCH ASSURANCE PLC','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1147';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1147','AXA WEALTH EUROPE S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1148';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1148','PROSIGHT SPECIALTY MANAGING AGENCY LIMITED','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1149';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1149','S2C S.P.A COMPAGNIA DI ASSICURAZIONI DI CREDIT E CAUZIONI','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1150';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1150','INTEGRALE LUXEMBOURG S.A','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1151';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1151','BUILDING BLOCK INSURANCE PCC LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1152';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1152','SKANDIA LEBEN (FL) AG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1153';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1153','UADB COMPENSA VIENNA INSURANCE GROUP','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1154';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1154','GRAWE ELETBIZTOSITO ZARTKORUEN MUKODO RESZVENYTARSASAG','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1155';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1155','PFA PENSION FORSIKRINGSAKTIESELSKAB','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1156';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1156','GREAT LAKES INSURANCE SE SUC.REINO UNIDO','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1157';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1157','GREAT LAKES INSURANCE SE SUC. ITALIA','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'L1158';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('L1158','NAVIGATORS INTERNATIONAL INSURANCE COMPANY LTD','','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0046';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0046','MUTUA DE SEGUROS DE ARMADORES DE BUQUES DE PESCA DE ESPAA, SOCIEDAD MUTUA A PRIMA FIJA','V28009561','915770937','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0048';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0048','LA UNION MONTIJANA, SEGUROS MUTUOS CONTRA INCENDIOS A PRIMA VARIABLE','J09031485','947-14.00.12','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0050';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0050','PELAYO, MUTUA DE SEGUROS Y REASEGUROS A PRIMA FIJA','G28031466','915920100','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0083';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0083','MUTUA MADRILEA AUTOMOVILISTA, SOCIEDAD DE SEGUROS A PRIMA FIJA','V28027118','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0084';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0084','MUTUA MMT SEGUROS, SOCIEDAD MUTUA DE SEGUROS A PRIMA FIJA','G28010817','915930100','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0102';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0102','MUTUAVENIR MUTUA DE SEGUROS Y REASEGUROS A PRIMA FIJA DE PAMPLONA','G31002041','948-22.76.04','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0107';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0107','MUSSAP- MUTUA DE SEGUROS Y REASEGUROS A PRIMA FIJA','G08171548','932956300','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0124';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0124','MUTUALIDAD ARROCERA DE SEGUROS A PRIMA FIJA','V46053245','963510917','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0134';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0134','FIATC, MUTUA DE SEGUROS Y REASEGUROS A PRIMA FIJA','G08171407','932052213','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0140';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0140','MUTUALIDAD DE LEVANTE, ENTIDAD DE SEGUROS A PRIMA FIJA','G03015914','902331515','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0167';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0167','MUTUA SEGORBINA DE SEGUROS A PRIMA FIJA','V12006268','964713636','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0177';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0177','PAKEA, MUTUALIDAD DE SEGUROS A PRIMA FIJA','V20027850','943427106','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0189';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0189','SOCIEDAD DE SEGUROS MUTUOS CONTRA INCENDIOS DE EDIFICIOS DE VALENCIA, MUTUA A FIJA','V46017091','963910618','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0191';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0191','SOLISS, MUTUALIDAD DE SEGUROS Y REASEGUROS A PRIMA FIJA','V45000734','925211200','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0199';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0199','MUTUA DE PROPIETARIOS, SEGUROS Y REASEGUROS A PRIMA FIJA','G08171332','932154116','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0212';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0212','SOCIEDAD DE SEGUROS MUTUOS MARITIMOS DE VIGO, MUTUALIDAD DE SEGUROS Y REASEGUROS A PRIMA FIJA','V36606184','986-43.29.33','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0216';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0216','MUTUA TINERFEA, MUTUA DE SEGUROS Y REASEGUROS A PRIMA FIJA','G38004297','922604817','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0327';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0327','MUTUALIDAD DE SEGUROS DE LA PANADERIA DE VALENCIA, MUTUA A PRIMA FIJA','J46093829','963918175','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0328';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0328','A.M.A. AGRUPACIN MUTUAL ASEGURADORA','G28177657','913459410','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0345';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0345','MUTUASPORT, MUTUA DE SEGUROS DEPORTIVOS A PRIMA FIJA','V28270015','915340444','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0353';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0353','SERAS, MUTUALIDAD DE SEGUROS A PRIMA FIJA','V28378180','914471150','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0363';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0363','UMAS, UNION MUTUA ASISTENCIAL DE SEGUROS A PRIMA FIJA','G28747574','913191010','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0368';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0368','MUSAAT, MUTUA DE SEGUROS A PRIMA FIJA','V28865855','917663144','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0369';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0369','ASEMAS-MUTUA DE SEGUROS Y REASEGUROS A PRIMA FIJA (con derrama pasiva)','V48148639','944235412','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0371';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0371','MUTUA DE RIESGO MARITIMO, SOCIEDAD DE SEGUROS A PRIMA FIJA (MURIMAR)','G78547148','915971835','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0373';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0373','AGROMUTUA-MAVDA, SOCIEDAD MUTUA DE SEGUROS A PRIMAFIJA','V46552824','902504443','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0374';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0374','SOCIEDAD DE SEGUROS MUTUOS CONTRA INCENDIOS DE EDIFICIOS RURALES DE ALAVA, MUTUA DE SEGUROS A PRIMA FIJA','G01014893','945138970','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0377';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0377','PREVISION SANITARIA NACIONAL, P.S.N. MUTUA DE SEGUROS Y REASEGUROS A PRIMA FIJA','V28230688','914311244','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0378';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0378','SVRNE, MUTUA DE SEGUROS Y REASEGUROS A PRIMA FIJA','V48083521','','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0379';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0379','MUTUA GENERAL DE CATALUA-MUTUA DE SEGUROS Y REASEGUROS A PRIMA FIJA','V08846644','934143600','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'M0380';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('M0380','NUEVA MUTUA SANITARIA DEL SERVICIO MDICO, MUTUA DE SEGUROS A PRIMA FIJA','V86444965','912908075','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P0023';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P0023','MUTUALIDAD DEL CLERO ESPAOL DE PREVISION SOCIAL A PRIMA FIJA','R2800231I','91-4.45.49.21','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P0034';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P0034','MUTUALIDAD DE PREVISION SOCIAL A PRIMA FIJA DE EMPLEADOS DE LA CAJA DE AHORROS DE VALENCIA','V46210357','963-69.96.78','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P0041';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P0041','ASOCIACION MUTUALISTA DE LA INGENIERIA CIVIL, MUTUALIDAD DE PREVISIN SOCIAL A PRIMA FIJA','G28012862','914231105','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P0046';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P0046','MONTEPIO DE ARTILLERIA, MUTUALIDAD DE PREVISIN SOCIAL A PRIMA FIJA','V28232841','91-4.48.61.41','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P0081';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P0081','PREVISION MUTUA DE APAREJADORES Y ARQUITECTOS TECNICOS MUTUALIDAD DE PREVISION SOCIAL A PRIMA FIJA','G28618536','91-5.72.08.12','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P0085';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P0085','ASOCIACION BENEFICA DE EMPLEADOS DEL BANCO DE ESPAA MUTUALIDAD DE PREVISION SOCIAL','G28231553','913384289','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P0089';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P0089','MONTEPIO DE CONDUCTORES DE AUTOMOVILES DE VALLADOLID Y PROVINCIA, MUTUALIDAD DE PREVISION SOCIAL','V47033147','983-29.76.42','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P0155';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P0155','SOCIEDAD FILANTROPICA DEL COMERCIO, INDUSTRIA Y BANCA DE MADRID, MUTUALIDAD DE PREVISION SOCIAL','V28264869','91-4.48.02.08','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P0159';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P0159','CENTRO DE PROTECCIN DE CHOFERES DE LA RIOJA, MUTUALIDAD DE PREVISIN SOCIAL A PRIMA FIJA','V26014316','941511510','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P0179';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P0179','EL VOLANTE ARAGONES, MONTEPIO DE CONDUCTORES DE PREVISION SOCIAL','V50047927','976-22.90.05','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P0226';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P0226','MUTUALIDAD DE EMPLEADOS DEL BANCO SANTANDER, MUTUALIDAD DE PREVISION SOCIAL A PRIMA FIJA','V39018726','942362143','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P0244';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P0244','MUTUALIDAD DE PREVISION SOCIAL DE AUTORES Y EDITORES','G28241834','91-5.03.68.42','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P0285';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P0285','UNION ESPAOLA DE CONDUCTORES DE AUTOMOVILES, MUTUALIDAD DE PREVISION SOCIAL A PRIMA FIJA','V28029023','91-5.22.75.11','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P0295';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P0295','MUTUALIDAD GENERAL DE PREVISION SOCIAL DE LOS GESTORES ADMINISTRATIVOS','G28263101','914312502','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P0427';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P0427','ASOCIACION DE SOCORROS DEL PERSONAL DEL BANCO ESPAOL DE CREDITO MUTUALIDAD DE PREVISION SOCIAL A PRIMA FIJA','G28238277','913383049','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P0810';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P0810','MONTEPIO DE TELEFONOS MUTUALIDAD DE PREVISIN SOCIAL A PRIMA FIJA','G28974392','915318031','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P1430';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P1430','CAJA DE SOCORROS INSTITUCIN POLICIAL, MUTUALIDAD DE PREVISION SOCIAL A PRIMA FIJA','V79361259','915318495','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P1639';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P1639','MUTUALIDAD DE PREVISION SOCIAL DE FUTBOLISTAS ESPAOLES A PRIMA FIJA','V85599645','914461408','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P1703';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P1703','MUTUALIDAD DE PREVISION SOCIAL DE PERITOS E INGENIEROS TECNICOS INDUSTRIALES A PRIMA FIJA','V28418838','913993155','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P1840';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P1840','ASOCIACION FERROVIARIA MEDICO FARMACEUTICA DE PREVISION SOCIAL, MUTUALIDAD DE PREVISION SOCIAL A PRIMA FIJA','G28556462','915280582','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P1875';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P1875','MUTUALIDAD DE EMPLEADOS DEL BANCO DE ESPAA, ENTIDAD DE PREVISION SOCIAL','V28234011','913087252','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P2131';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P2131','MUTUALIDAD GENERAL DE LA ABOGACIA MUTUALIDAD DE PREVISION SOCIAL A PRIMA FIJA','V28024149','914352486','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P2136';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P2136','MUTUALIDAD DE PREVISIN SOCIAL DE ARAGONESAS A PRIMA FIJA','V28870715','917818934','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P2300';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P2300','UNIN SANITARIA MEDICO-QUIRURGICA, MUTUALIDAD DE PREVISIN SOCIAL','G78023538','915752781','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P2345';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P2345','MUTUALIDAD DE PREVISION SOCIAL DE VIAJANTES Y REPRESENTANTES DE COMERCIO DE ESPAA A PRIMA FIJA','G28736726','915221070','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P2381';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P2381','MUTUALIDAD GENERAL DE PREVISION DEL HOGAR DIVINA PASTORA, MUTUALIDAD DE PREVISION SOCIAL A PRIMA FIJA','V46055810','963113340','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P2397';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P2397','MUTUALIDAD DE PREVISION SOCIAL DE LAS ARTES DEL LIBRO, ARLI A PRIMA FIJA','G78029501','915317619','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P2605';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P2605','MUTUALIDAD DE PREVISION SOCIAL A PRIMA FIJA PARA EL PERSONAL DE MICHELIN ESPAA PORTUGAL, S.A.','V20080040','983353000','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P2636';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P2636','MUTUALIDAD ESCOLAR DE PREVISION SOCIAL A PRIMA FIJA JESUS MARIA','G79068128','914319520','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P2651';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P2651','MUTUA DE PREVISION SOCIAL A PRIMA FIJA DEL PERSONAL DE RENAULT ESPAA, MUTUALIDAD DE PREVISIN SOCIAL','V47005640','9830305381','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P2714';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P2714','MUTUALIDAD DE PREVISION SOCIAL DE EMPLEADOS DE BANCAJA, A PRIMA FIJA','V46118493','963699678','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P2925';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P2925','MUTUALIDAD ESCOLAR Y FAMILIAR DE PREVISION SOCIAL','V28207116','914000500','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P2994';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P2994','LORETO MUTUA, MUTUALIDAD DE PREVISION SOCIAL','V28277002','917589650','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P2997';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P2997','MUTUALIDAD DE PREVISION SOCIAL DE LOS PROCURADORES DE LOS TRIBUNALES DE ESPAA','V85599611','913082163','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P3028';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P3028','HERMANDAD NACIONAL DE ARQUITECTOS SUPERIORES Y QUIMICOS, MUTUALIDAD DE PREVISION SOCIAL A PRIMA FIJA','V28306678','913834700','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P3074';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P3074','MUTUALIDAD COMPLEMENTARIA DE PREVISION SOCIAL RENAULT ESPAA','V28499143','913742112','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P3132';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P3132','PREVISION BALEAR, MUTUALIDAD DE PREVISIN SOCIAL A PRIMA FIJA','V07103419','971720210','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P3138';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P3138','MUTUALIDAD DE PREVISION SOCIAL DE ASISA "DR. ATILANO CEREZO"','G78022142','915957500','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P3141';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P3141','MUTUALIDAD DE PREVISIN SOCIAL A PRIMA FIJA DEL COLEGIO OFICIAL DE INGENIEROS NAVALES Y OCENICOS','G28895787','915751024','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P3142';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P3142','MUTUALIDAD ESCOLAR SEK DE PREVISION SOCIAL GENERAL A PRIMA FIJA','V28881720','916616650','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P3143';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P3143','MUTUALIDAD DE PREVISION SOCIAL FONDO DE ASISTENCIA MUTUA DEL COLEGIO DE INGENIEROS DE CAMINOS, CANALE S Y PUERTOS','V78293719','913191000','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P3151';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P3151','MUTUALIDAD DE PREVISION SOCIAL DE LA POLICIA A PRIMA FIJA Y A PRIMA VARIABLE','V28809226','914681555','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P3152';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P3152','MUTUALIDAD DE PREVISION SOCIAL A PRIMA FIJA DEL COLEGIO DE MINAS DE LEON,PALENCIA,BURGOS Y CANTABRIA','G24235897','987231937','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P3156';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P3156','MUTUALIDAD DE DEPORTISTAS PROFESIONALES, MUTUALIDAD DE PREVISIN SOCIAL A PRIMA FIJA','G82699653','913143030','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P3157';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P3157','MUTUAL MEDICA DE CATALUNYA I BALEARS, MUTUALIDAD DE PREVISION SOCIAL A PRIMA FIJA','V08475766','933197800','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P3158';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P3158','PURISIMA CONCEPCION, MUTUALIDAD DE PREVISION SOCIAL','V84283837','915223784','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P3159';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P3159','MUTUALITAT DE PREVISI SOCIAL DEL COLLEGI OFICIAL D*ENGINYERS INDUSTRIALS DE CATALUNYA A PRIMA FIXA','V08430191','932954300','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P3161';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P3161','ALTER MTUA DE PREVISI SOCIAL DELS ADVOCATS DE CATALUNYA A PRIMA FIXA','V08264178','932077775','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P3162';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P3162','PREVISORA GENERAL, MUTUALIDAD DE PREVISIN SOCIAL A PRIMA FIJA','V58782145','933041600','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'P3163';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('P3163','MUTUAL DE CONDUCTORS, Mutualidad de Previsin Social a Prima Fija','V62390588','934534005','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'R0011';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('R0011','NACIONAL DE REASEGUROS, S.A.','A28030369','913081412','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'R0019';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('R0019','MAPFRE RE, COMPAIA DE REASEGUROS, S.A.','A78346558','91-5.81.16.00','Activa',0);
DELETE FROM P06B23T00_ENT_ASEGURADORAS WHERE P06B23_EA_CLAVE = 'R1000';
INSERT INTO P06B23T00_ENT_ASEGURADORAS (P06B23_EA_CLAVE,P06B23_EA_ENTIDAD,P06B23_EA_CIF,P06B23_EA_TELEFONO,P06B23_EA_ESTADO,P06B23_EA_BAJA) VALUES ('R1000','GCO REASEGUROS, S.A.','A66329228','','Activa',0);

COMMIT;

exit;
